<?php

App::uses('MigrationUtil', 'EvMigrationUtil.Lib');

class SaveMenuPagesStatusesAndSiteSettings extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'save_menu_pages_statuses_and_site_settings';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(),
		'down' => array(),
	);

	private $__direction = 'up';

	private $__transaction = null;

	private $__migrationUtilities = [];

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		$this->__setupMigration($direction);

		if ($this->__direction == 'down') {
			return $this->__succeedMigration();
		}

		$migrated = $this->__migrateMenus();

		if (!$migrated) {
			return $this->__failMigration();
		}

		$migrated = $this->__migratePages();

		if (!$migrated) {
			return $this->__failMigration();
		}

		$migrated = $this->__migrateStatuses();

		if (!$migrated) {
			return $this->__failMigration();
		}

		$migrated = $this->__migrateSiteSettings();

		if (!$migrated) {
			return $this->__failMigration();
		}

		return $this->__succeedMigration();
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}

/**
 * Setup the direction, transaction and migration utilities for the current migration.
 *
 * @param string $direction 'up'|'down'.
 * @return void.
 */
	private function __setupMigration($direction) {
		$this->__direction = $direction;

		$this->__migrationUtilities = [
			'Menu' => MigrationUtil::init('EvNavigation.Menu'),
			'Template' => MigrationUtil::init('EvTemplates.Template'),
			'Page' => MigrationUtil::init('EvCore.Page'),
			'OrderStatus' => MigrationUtil::init('EvCheckout.OrderStatus'),
			'SiteSettingCategory' => MigrationUtil::init('EvSiteSettings.SiteSettingCategory'),
			'SiteSetting' => MigrationUtil::init('EvSiteSettings.SiteSetting'),
		];

		$this->__transaction = $this->__migrationUtilities['Menu']->Model->getDataSource();

		$this->__transaction->begin();
	}

/**
 * Mark the migration as failed.
 *
 * @return bool.
 */
	private function __failMigration() {
		$this->__transaction->rollback();

		return false;
	}

/**
 * Mark the migration as successful.
 *
 * @return bool.
 */
	private function __succeedMigration() {
		$this->__transaction->commit();

		return true;
	}

/**
 * Migrate the EvCheckout admin menus.
 *
 * @return bool.
 */
	private function __migrateMenus() {
		$menuAlias = $this->__migrationUtilities['Menu']->Model->alias;

		return (bool)$this->__migrationUtilities['Menu']->createOnce(
			[
				$menuAlias . '.plugin' => 'EvCheckout',
				$menuAlias . '.controller' => 'ev_checkout.orders',
				$menuAlias . '.action' => 'index',
			],
			[
				$menuAlias => [
					'parent_id' => 1,
					'name' => 'Orders',
					'pattern' => '/^\/admin\/ev_checkout\//',
					'plugin' => 'EvCheckout',
					'controller' => 'ev_checkout.orders',
					'model' => 'Order',
					'action' => 'index',
					'class' => 'icon-gbp',
					'is_active' => true,
				],
			]
		);
	}

/**
 * Migrate the EvCheckout pages.
 *
 * @return bool.
 */
	private function __migratePages() {
		$templates = [
			[
				'name' => 'Order Successful',
				'template' => 'EvCheckout./Templates/Order/successful',
				'helperFunction' => 'N/A',
				'cfDataLabel' => 'Custom Data',
				'model' => 'Page',
				'is_active' => true,
			],
			[
				'name' => 'Order Failed',
				'template' => 'EvCheckout./Templates/Order/fail',
				'helperFunction' => 'N/A',
				'cfDataLabel' => 'Custom Data',
				'model' => 'Page',
				'is_active' => true,
			],
			[
				'name' => 'Order Cancelled',
				'template' => 'EvCheckout./Templates/Order/cancelled',
				'helperFunction' => 'N/A',
				'cfDataLabel' => 'Custom Data',
				'model' => 'Page',
				'is_active' => true,
			],
		];

		$createdTemplates = (bool)$this->__migrationUtilities['Template']->createAllOnce(
			[
				'template',
				'model'
			],
			$templates
		);

		if (!$createdTemplates) {
			return false;
		}

		$templateIds = $this->__migrationUtilities['Template']->Model->find(
			'list',
			[
				'fields' => [
					'name',
					'id'
				],
				'callbacks' => false,
				'limit' => 3,
				'order' => 'Template.id DESC'
			]
		);

		if (
			empty($templateIds['Order Successful'])
			|| empty($templateIds['Order Failed'])
			|| empty($templateIds['Order Cancelled'])
		) {
			return false;
		}

		$pages = [
			[
				'title' => 'Order Successful',
				'internal_title' => 'order_successful',
				'body' => '<p>Your order (#ORDERID) was placed successfully. You shall receive a confirmation email shortly.</p>',
				'is_active' => true,
				'is_protected' => true,
				'template_id' => $templateIds['Order Successful'],
			],
			[
				'title' => 'Order Failed',
				'internal_title' => 'order_failed',
				'body' => '<p>There was a problem completing your order, please try again. If the problem persists, please contact us.</p>',
				'is_active' => true,
				'is_protected' => true,
				'template_id' => $templateIds['Order Failed'],
			],
			[
				'title' => 'Order Cancelled',
				'internal_title' => 'order_cancelled',
				'body' => '<p>The checkout process was cancelled.</p>',
				'is_active' => true,
				'is_protected' => true,
				'template_id' => $templateIds['Order Cancelled'],
			],
		];

		return (bool)$this->__migrationUtilities['Page']->createAllOnce(
			[
				'internal_title'
			],
			$pages
		);
	}

/**
 * Migrate the EvCheckout order statuses.
 *
 * @return bool.
 */
	private function __migrateStatuses() {
		$statuses = [
			[
				'name' => 'Awaiting Payment',
				'slug' => 'awaiting_payment',
				'sequence' => 10,
				'is_selectable' => true,
				'is_active' => true,
			],
			[
				'name' => 'Paid',
				'slug' => 'paid',
				'sequence' => 20,
				'is_selectable' => true,
				'is_active' => true,
			],
			[
				'name' => 'Shipped',
				'slug' => 'shipped',
				'sequence' => 30,
				'is_selectable' => true,
				'is_active' => true,
			],
		];

		return (bool)$this->__migrationUtilities['OrderStatus']->createAllOnce(
			[
				'slug'
			],
			$statuses
		);
	}

/**
 * Migrate the EvCheckout site settings.
 *
 * @return bool.
 */
	private function __migrateSiteSettings() {
		$categoryId = $this->__migrationUtilities['SiteSettingCategory']->createOnce(
			[
				'array_slug' => 'ev_checkout'
			],
			[
				'name' => 'Checkout',
				'array_slug' => 'ev_checkout',
				'sequence' => 15,
				'prevent_edit' => false,
			]
		);

		if (empty($categoryId)) {
			return false;
		}

		$settings = [
			[
				'name' => 'New Order Notification Email',
				'array_slug' => 'new_order_email',
				'value' => 'admin@evoluted.net',
				'type' => 'string',
				'sequence' => 10,
				'site_setting_category_id' => $categoryId,
				'prevent_edit' => false,
			],
			[
				'name' => 'New Order Notification Name',
				'array_slug' => 'new_order_name',
				'value' => 'Admin',
				'type' => 'string',
				'sequence' => 20,
				'site_setting_category_id' => $categoryId,
				'prevent_edit' => false,
			],
			[
				'name' => 'Enable Adwords Conversion Tracking?',
				'array_slug' => 'enable_conversion_tracking',
				'value' => '1',
				'type' => 'boolean',
				'sequence' => 30,
				'site_setting_category_id' => $categoryId,
				'prevent_edit' => false,
			],
			[
				'name' => 'Adwords Conversion ID',
				'array_slug' => 'google_conversion_id',
				'value' => '',
				'type' => 'string',
				'sequence' => 40,
				'site_setting_category_id' => $categoryId,
				'prevent_edit' => false,
			],
			[
				'name' => 'Adwords Conversion Label',
				'array_slug' => 'google_conversion_label',
				'value' => '',
				'type' => 'string',
				'sequence' => 50,
				'site_setting_category_id' => $categoryId,
				'prevent_edit' => false,
			],
		];

		return (bool)$this->__migrationUtilities['SiteSetting']->createAllOnce(
			[
				'array_slug',
				'site_setting_category_id'
			],
			$settings
		);
	}
}
