<?php
class AddOrderUpdatedEmailTemplate extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'add_order_updated_email_template';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
		),
		'down' => array(
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		$Email = EvClassRegistry::init('EvEmail.Email');

		if ($direction == 'up') {
			$group = $Email->EmailGroup->findByName('EvCheckout');
			$Email->save([
				'Email' => [
					'name' => 'Order Updated - Customer',
					'system_name' => 'EvCheckoutOrderUpdated',
					'email_group_id' => $group['EmailGroup']['id'],
					'subject' => 'Your order has been updated',
					'content' => '<p>Dear {customerName},</p><p>Order #{orderNumber} that you placed on {siteTitle} has been updated. Login to <a href="{viewOrderUrl}">My Orders</a> for more information.</p>{==content==}',
					'required_tokens' => 'customerName, orderNumber, ==content==',
					'optional_tokens' => 'siteTitle, viewOrderUrl',
				]
			]);
		} else {
			$Email->deleteAll([
				'system_name' => 'EvCheckoutOrderUpdated'
			]);
		}

		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
