<?php

App::uses('MigrationUtil', 'EvMigrationUtil.Lib');

class AddOrderEmailTemplates extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'add_order_email_templates';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
		),
		'down' => array(
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		$EmailGroupUtil = MigrationUtil::init('EvEmail.EmailGroup');
		$EmailUtil = MigrationUtil::init('EvEmail.Email');

		if ($direction == 'up') {
			$checkoutGroupId = $EmailGroupUtil->createOnce(
				[
					$EmailGroupUtil->Model->alias . '.name' => 'EvCheckout',
				],
				[
					$EmailGroupUtil->Model->alias => [
						'name' => 'EvCheckout',
					],
				]
			);

			if (empty($checkoutGroupId)) {
				return false;
			}

			return (bool)$EmailUtil->createAllOnce(
				[
					'system_name',
				],
				[
					[
						$EmailUtil->Model->alias => [
							'name' => 'EvCheckout Status Update Customer Paid',
							'system_name' => 'EvCheckoutStatusUpdateCustomerPaid',
							'email_group_id' => $checkoutGroupId,
							'subject' => Configure::read('SiteSetting.general.site_title'),
							'content' => '
								<p>Dear {customerName},</p>
								<p>Thank you for your order (#{orderNumber}). See below for confirmation of what you have ordered.</p>
								<p>{==content==}</p>
							',
							'required_tokens' => 'customerName, orderNumber, ==content==',
							'optional_tokens' => '',
							'from_name' => '',
							'from_email' => '',
							'override_to' => false,
							'to_name' => null,
							'to_email' => null,
							'is_active' => true,
						],
					],
					[
						$EmailUtil->Model->alias => [
							'name' => 'EvCheckout Status Update Admin Paid',
							'system_name' => 'EvCheckoutStatusUpdateAdminPaid',
							'email_group_id' => $checkoutGroupId,
							'subject' => Configure::read('SiteSetting.general.site_title'),
							'content' => '
								<p>A new order has been made by {customerName}</p>
								<p>The order number is (#{orderNumber}). See below for confirmation of what they have ordered.</p>
								<p>{==content==}</p>
							',
							'required_tokens' => 'customerName, orderNumber, ==content==',
							'optional_tokens' => '',
							'from_name' => '',
							'from_email' => '',
							'override_to' => false,
							'to_name' => null,
							'to_email' => null,
							'is_active' => true,
						],
					],
					[
						$EmailUtil->Model->alias => [
							'name' => 'EvCheckout Status Update Customer Shipped',
							'system_name' => 'EvCheckoutStatusUpdateCustomerShipped',
							'email_group_id' => $checkoutGroupId,
							'subject' => Configure::read('SiteSetting.general.site_title'),
							'content' => '
								<p>Dear {customerName},</p>
								<p>Your order (#{orderNumber}) has been shipped. You can expect it to arrive in 14 days. As a reminder your order is being sent to the following address.</p>
								<p>{==content==}</p>
							',
							'required_tokens' => 'customerName, orderNumber, ==content==',
							'optional_tokens' => '',
							'from_name' => '',
							'from_email' => '',
							'override_to' => false,
							'to_name' => null,
							'to_email' => null,
							'is_active' => true,
						],
					],
				]
			);
		}

		$deletedEmails = $EmailUtil->deleteAll(
			[
				$EmailUtil->Model->alias . '.system_name' => [
					'EvCheckoutStatusUpdateCustomerPaid',
					'EvCheckoutStatusUpdateAdminPaid',
					'EvCheckoutStatusUpdateCustomerShipped',
				],
			]
		);

		if (!$deletedEmails) {
			return false;
		}

		return $EmailGroupUtil->deleteIfExists(
			[
				$EmailGroupUtil->Model->alias . '.name' => 'EvCheckout',
			]
		);
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
