<?php

class AddingSlugToOrderStatusesAndOrderItemStatuses extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'adding_slug_to_order_statuses_and_order_item_statuses';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'ev_checkout_order_statuses' => array(
					'slug' => array('type' => 'string', 'null' => false, 'default' => null, 'length' => 254, 'collate' => 'utf8mb4_unicode_ci', 'charset' => 'utf8mb4', 'after' => 'name'),
				),
				'ev_checkout_order_item_statuses' => array(
					'slug' => array('type' => 'string', 'null' => false, 'default' => null, 'length' => 254, 'collate' => 'utf8mb4_unicode_ci', 'charset' => 'utf8mb4', 'after' => 'name'),
				),
			),
		),
		'down' => array(
			'drop_field' => array(
				'ev_checkout_order_statuses' => array(
					'slug',
				),
				'ev_checkout_order_item_statuses' => array(
					'slug',
				)
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction == 'up') {
			$OrderStatus = EvClassRegistry::init('EvCheckout.OrderStatus');

			//Update Awaiting Payment status
			$updateStatus = $OrderStatus->find(
				'first',
				[
					'conditions' => [
						'OrderStatus.id' => 1,
						'OrderStatus.name' => 'Awaiting Payment'
					]
				]
			);

			if (!empty($updateStatus)) {
				$updateStatus['OrderStatus']['slug'] = 'awaiting_payment';
				$OrderStatus->create();
				$OrderStatus->save($updateStatus);
			}

			//Update Paid status
			$updateStatus = $OrderStatus->find(
				'first',
				[
					'conditions' => [
						'OrderStatus.id' => 2,
						'OrderStatus.name' => 'Paid'
					]
				]
			);

			if (!empty($updateStatus)) {
				$updateStatus['OrderStatus']['slug'] = 'paid';
				$OrderStatus->create();
				$OrderStatus->save($updateStatus);
			}

			//Update Shipped status
			$updateStatus = $OrderStatus->find(
				'first',
				[
					'conditions' => [
						'OrderStatus.id' => 3,
						'OrderStatus.name' => 'Shipped'
					]
				]
			);

			if (!empty($updateStatus)) {
				$updateStatus['OrderStatus']['slug'] = 'shipped';
				$OrderStatus->create();
				$OrderStatus->save($updateStatus);
			}
		}

		return true;
	}
}
