<?php

class OrderPaymentHelper extends AppHelper {

/**
 * Build the link for the external payment gateway from the transaction data
 */
	public function buildExternalTransactionUrl($transaction) {
		$paymentToken = json_decode($transaction['payment_token']);

		if (empty($paymentToken)) {
			return false;
		}

		$paymentMethod = $this->_getPaymentType($transaction);

		// Set subdomain based on whether we on live/internal/local
		if (Configure::read('app.environment') == 'DEVELOPMENT') {
			$subdomain = 'test';
		} elseif (Configure::read('app.environment') == 'PRODUCTION') {
			$subdomain = 'live';
		}

		if ($paymentMethod == 'EvSagePay.SagePay') {
			return "<strong>SagePay:</strong>
			<a target='_blank' href='https://$subdomain.sagepay.com/mysagepay/transactiondetail.msp?transactionID=$paymentToken->VPSTxId'>Click here to view order</a>";
		} elseif ($paymentMethod == 'EvPaypal.Paypal') {
			return "<strong>Paypal:</strong>
			<a target='_blank' href='https://history.paypal.com/webscr?cmd=_history-details-from-hub&id=$paymentToken->TransactionId'>Click here to view order</a>";
		} else {
			return "<strong>Payment Method: $paymentMethod";
		}
	}

	protected function _getPaymentType($transaction) {
		return $transaction['payment_method'];
	}

}
