<?php if (! empty($transactions)): ?>
	<div class="row">
		<div class="col-xs-12">
			<div class="panel panel-primary">
				<div class="panel-heading"><h3 class="panel-title">Transactions</h3></div>
				<div class="panel-body">
				<?php foreach ($transactions as $transaction): ?>
					<?php
					$transactionUrl = array(
						'admin' => true,
						'plugin' => 'ev_transactions',
						'controller' => 'transactions',
						'action' => 'view',
						$transaction['Transaction']['id']
					);
					?>
					<div class="well well-sm">
						<strong>Transaction ID: </strong> <?=$this->Html->link('#' . $transaction['Transaction']['id'], $transactionUrl, ['target' => '_blank'])?><br>
						<strong>Status:</strong> <?=Inflector::humanize($transaction['Transaction']['status'])?><br>
						<?php if (!empty($transaction['Transaction']['message'])): ?>
							<strong>Information:</strong> <?= str_replace("Warning:", "<span class=\"label label-danger\">WARNING:</span>", $transaction['Transaction']['message']) ?><br>
						<?php endif; ?>
						<strong>Total:</strong> <?=$this->Number->currency($transaction['Transaction']['transaction_amount'], $currencies[$transaction['Transaction']['currency_id']])?><br>
						<strong>Date:</strong> <?=$this->Time->format('d/m/Y H:i', $transaction['Transaction']['created'])?><br>
						<?= $this->OrderPayment->buildExternalTransactionUrl($transaction['Transaction']) ?>
					</div>
				<?php endforeach;?>
				</div>
			</div>
		</div>
	</div>
<?php endif; ?>
