<?php
//Get the tracking ID
if(!isset($trackingCode)):
	$trackingCode = Configure::read('SiteSetting.general.google_analytics');
endif;

if($trackingCode && Configure::read('app.environment') !== 'DEVELOPMENT'): ?>
	<?php if (! empty($completeOrder['Order'])): ?>
		<script type="text/javascript">

			// Check it's not already been sent first
			var ecommerceCookie = 'order' + <?= h($completeOrder['Order']['id']) ?> + '-ecommerce=success';
			if (document.cookie.indexOf(ecommerceCookie) === -1) {

				ga('require', 'ecommerce');
				ga('ecommerce:addTransaction', {
				  'id': '<?=$completeOrder['Order']['id']?>',                     // Transaction ID. Required.
				  'affiliation': '<?=Configure::read('SiteSetting.general.site_title')?>',   // Affiliation or store name.
				  'revenue': '<?=$orderTotal?>',               // Grand Total.
				  <?php if (($deliveryTotal = $this->Order->getOrderTotalValue($completeOrder['OrderTotal'], Configure::read('EvBasket.labels.delivery'))) !== null): ?>
				  	'shipping': '<?= round($deliveryTotal, 2) ?>', // Delivery total
				  <?php endif ?>
				  <?php if (($taxTotal = $this->Order->getOrderTotalValue($completeOrder['OrderTotal'], Configure::read('EvBasket.labels.tax'), false)) !== null): ?>
				  	'tax': '<?= round($taxTotal, 2)?>', // Tax total
				  <?php endif ?>
				});

				<?php if (! empty($completeOrder['OrderItem'])): ?>
					<?php foreach ($completeOrder['OrderItem'] as $Item): ?>
						<?php
							if (! empty($Item['OrderItemData']['sku'])):
								$sku = $Item['OrderItemData']['sku'];
							else:
								$sku = $Item['id'];
							endif;
						?>
						ga('ecommerce:addItem', {
						  'id': '<?=$completeOrder['Order']['id']?>', // Transaction ID. Required.
						  'name': '<?= str_replace("'", "\\'", $Item['name']); ?>', // Product name. Required.
						  'sku': '<?=$sku?>', // SKU/code.
						  'category': '', // Category or variation.
						  'price': '<?=number_format($Item['unit_price'], 2, '.', '')?>', // Unit price.
						  'quantity': '<?=$Item['quantity']?>' // Quantity.
						});
					<?php endforeach; ?>
				<?php endif; ?>

				ga('ecommerce:send'); //submits transaction to the Analytics servers

				// Save a week-long cookie to record that this tracking
				// has already been sent
				var expires = new Date();
				expires.setDate(expires.getDate() + 7);
				document.cookie = ecommerceCookie + '; expires=' + expires.toUTCString() + ';';
			}

		</script>
	<?php endif; ?>
<?php endif; ?>
