<?php
	if (!isset($admin)):
		$admin = false;
	endif;

	if (empty($notes) && !empty($this->request->data['OrderNote'])):
		$notes = $this->Order->getOrderNotes($this->request->data['OrderNote'], $admin);
	endif;
?>

<div class="container-fluid">
	<div class="row">
		<div class="col-xs-12">
			<h3><?= $admin ? 'Admin ' : 'Customer ' ?>Notes</h3>
			<?php if (!empty($notes)): ?>
				<table>
					<tr>
						<th>Note</th>
						<th>User</th>
						<th>Date</th>
					</tr>
					<?php foreach ($notes as $note): ?>
						<?php if (!empty($note['note'])) :?>
							<tr>
								<td>
									<?php
										echo $note['note']
									?>
								</td>
								<td>
									<?php
										if (!empty($note['user_id']) && !empty($note['User'])):
											echo $note['User']['first_name'] . ' ' . $note['User']['last_name'];
										else:
											echo 'System';
										endif;
									?>
								</td>
								<td>
									<?php
										$noteDate = DateTime::createFromFormat('Y-m-d H:i:s', $note['created']);
										if (!empty($noteDate)) {
											echo $noteDate->format('d-m-Y H:i:s');
										}
									?>
								</td>
							</tr>
						<?php endif; ?>
					<?php endforeach; ?>
				</table>
			<?php else: ?>
				<p>There are no notes.</p>
			<?php endif; ?>

			<?php
				if (!empty($this->request->data['Order']['id'])):
					echo $this->Form->create(
						'OrderNote',
						[
							'url' => [
								'plugin' => 'ev_checkout',
								'admin' => true,
								'controller' => 'order_notes',
								'action' => 'add',
								$this->request->data['Order']['id']
							]
						]
					);

					echo $this->Form->addField(
						'is_admin_note',
						[
							'type' => 'hidden',
							'value' => $admin,
						]
					);

					if ($admin) {
						$noteLabel = 'Add new admin note';
					} else {
						$noteLabel = 'Add new note (visible to customers)';
					}
					echo $this->Form->addField(
						'note',
						[
							'type' => 'textarea',
							'rows' => 5,
							'label' => $noteLabel,
						]
					);
			?>
				<div class="order-actions">
					<?php
						echo $this->Form->button(
							'Add Note',
							[
								'type' => 'submit',
								'name' => 'submit',
								'class' => 'btn btn-primary'
							]
						);
					?>
				</div>

				<?= $this->Form->end(); ?>
			<?php endif; ?>
		</div>
	</div>
</div>
