<div class="row">
	<div class="col-xs-12 col-sm-6">
		<h1 class="title">Order <span>Items</span></h1>
	</div>
	<div class="col-xs-12 col-sm-6 text-right">
		<h3 style="line-height:38px;">
			<?php
				echo count($this->request->data['OrderItem']) . ' item(s) totalling ';

				$grandTotal = end($this->request->data['OrderTotal']);

				echo $this->Number->currency(
					$grandTotal['amount'],
					$currencies[$this->request->data['Order']['currency_id']]
				);
			?>
		</h3>
	</div>
</div>

<?php
	if (! empty($hasOrderItemStatuses)):
		echo $this->Form->create('OrderItem', array(
				'url' => array(
					'plugin' => 'ev_checkout',
					'controller' => 'order_items',
					'action' => 'update_statuses',
				),
				'onsubmit' => "return confirm('Please confirm that you would like to update the item status');"
			)
		);
	endif;
?>

<div class="row">
	<div class="col-xs-12">
		<table class="results results-borderless">
			<thead>
				<tr>
					<th>Item</th>
					<?php
						if (! empty($hasOrderItemStatuses)):
					?>
							<th>Item Status</th>
					<?php
						endif;
					?>
					<th>Price</th>
					<th>Quantity</th>
					<th class="basket__total">Total</th>
				</tr>
			</thead>

			<tbody>
				<?php
					if (! empty($this->request->data['OrderItem'])):
						$i = 0;

						foreach ($this->request->data['OrderItem'] as $Item):
				?>
							<tr>
								<td>
									<?=$Item['name']?><br>
									<?php if (! empty($Item['OrderItemData'])): ?>
										<?php $quantityReturned = 0; ?>
										<?php $returnStockUpdated = true; ?>
										<?php foreach ($Item['OrderItemData'] as $label => $value): ?>
											<?php
												if ($label == 'quantity_returned') {
													$quantityReturned = $value;
													continue;
												} elseif ($label == 'return_stock_updated') {
													$returnStockUpdated = $value;
													continue;
												}
											?>
											[<?=$label?>: <?=$value?>]
										<?php endforeach; ?>
										<?php if (!empty(Configure::read('EvCheckout.allowReturningItems')) && !empty($quantityReturned)): ?>
											<br><span class="order-item__return-info">Quantity returned: <?=$quantityReturned?></span>
											<?php if ($returnStockUpdated == 0): ?>
												<span class="order-item__return-info">(Stock not updated)</span>
											<?php endif ?>
										<?php endif; ?>
										<?php if (!empty(Configure::read('EvCheckout.allowReturningItems')) && $quantityReturned < $Item['quantity']):?>
											<br>
											<?= $this->Html->link( 'Return this item', '', [
												'data-toggle' => 'collapse',
												'data-target' => '#ItemReturnForm' . $Item['id'],
												'onclick' => 'return false;' // This was the only way I could find to stop it navigating away without extra js
											]) ?>
											<div id="<?= 'ItemReturnForm' . $Item['id']?>" class="collapse">
												<?php
													echo $this->Form->create(
														$primaryModel,
														array(
															'url' => array(
																'action' => 'return'
															),
															'onsubmit' => "return confirm('Are you sure you want to return " . $Item['name'] . "?');",
														)
													);
												?>

												<?php
													echo $this->Form->hidden('OrderItem.id', ['value' => $Item['id']]);
													echo $this->Form->addField('OrderItem.quantity', [
														'type' => 'integer',
														'div' => 'order-return-input',
														'label' => 'Quantity to Return',
													]);
													echo $this->Form->button('Return', [
														'class' => 'btn btn-danger btn-block'
													]);

													echo $this->Form->end();
												?>
											</div>

										<?php endif; ?>
									<?php endif; ?>
								</td>
								<?php
									if (! empty($hasOrderItemStatuses)):
								?>
										<td>
											<?php
												echo $this->Form->input('OrderItem.' . $i . '.id', [
													'type' => 'hidden',
													'value' => $Item['id']
												]);

												echo $this->Form->input('OrderItem.' . $i . '.order_id', [
													'type' => 'hidden',
													'value' => $Item['order_id']
												]);

												echo $this->Form->select(
													'OrderItem.' . $i . '.order_item_status_id',
													$orderItemStatuses,
													[
														'class' => 'form-control',
														'empty' => false,
														'value' => ! empty($Item['order_item_status_id']) ? $Item['order_item_status_id'] : false

													]
												);
											?>
										</td>
								<?php
									endif;
								?>
								<td><?=$this->Number->currency($Item['unit_price'], $currencies[$this->request->data['Order']['currency_id']])?></td>
								<td><?=$Item['quantity']?></td>
								<td class="basket__total">
									<?=$this->Number->currency($Item['row_total'], $currencies[$this->request->data['Order']['currency_id']])?>
								</td>
							</tr>
				<?php
							$i++;
						endforeach;
					endif;
				?>
			</tbody>

			<tfoot>
				<?php
					if (! empty($this->request->data['OrderTotal'])):
						$totalsColSpan = ! empty($hasOrderItemStatuses) ? 4 : 3;
						foreach ($this->request->data['OrderTotal'] as $Total):
				?>
							<tr>
								<td colspan="<?= $totalsColSpan ?>" class="text--right">
									<strong><?= $Total['name'] ?></strong>
								</td>
								<td class="basket__total">
									<?php
										$displayTotal = $Total['amount'];
										if (!empty($Total['display_ex_tax']) && $Total['display_ex_tax'] > 0):
											$displayTotal = $Total['display_ex_tax'];
										endif;

										echo $this->Number->currency(
											$displayTotal,
											$currencies[$this->request->data['Order']['currency_id']]
										);
									?>
								</td>
							</tr>
				<?php
						endforeach;
					endif;
				?>
			</tfoot>
		</table>
	</div>
</div>

<?php
	if (! empty($hasOrderItemStatuses)):
?>
		<div class="row">
			<div class="col-xs-12">
				<div class="text-right" style="padding-bottom:20px;padding-top:20px;">
					<?php
						echo $this->Form->button('Save Item Status', [
							'class' => 'btn btn-primary btn-save-statuses',
							'type' => 'submit'
						]);
					?>
				</div>
			</div>
		</div>
<?php
		echo $this->Form->end();
	endif;
?>
