<?php
App::uses('EvCheckoutAppModel', 'EvCheckout.Model');
/**
 * OrderStatus Model
 *
 * @property Order $Order
 */
class OrderStatus extends EvCheckoutAppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'name';

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'name' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				'message' => 'Status name must be filled in'
			),
		),
		'slug' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				'message' => 'Status slug must be filled in'
			),
		),
	);

	//The Associations below have been created with all possible keys, those that are not needed can be removed

/**
 * hasMany associations
 *
 * @var array
 */
	public $hasMany = array(
		'Order' => array(
			'className' => 'EvCheckout.Order'
		)
	);

	/**
	 * set constants to define unpaid / paid statuses
	 */
	const
		UNPAID = 1,
		PAID = 2;

/**
 * Get the Id of an order status by it's slug value.
 *
 * @param string $slug The slug of the status to search for.
 * @return int|null The Id is returned if found, otherwise null is returned.
 */
	public function getStatusIdBySlug($slug) {
		$status = $this->findBySlug($slug);

		if (!empty($status[$this->alias]['id'])) {
			return $status[$this->alias]['id'];
		}

		return null;
	}
}
