<?php

App::uses('CakeEventListener', 'Event');

class OrderStatusChangedListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'EvCheckout.Component.Order.statusChanged' => 'sendStatusConfirmationEmails'
		);
	}

	public function sendStatusConfirmationEmails(CakeEvent $Event) {
		// Event subject will be the OrderManager Component
		// call straight to the queue email method
		$Event->subject()->sendStatusUpdateEmail($Event->data['orderId'], $Event->data['statusId']);
	}

}
