<?php

App::uses('CakeEventListener', 'Event');

class EvCheckoutLogoutGuestUserListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'EvCheckout.Controller.Order.success' => 'logoutGuestUser',
			'EvCheckout.Controller.Order.fail' => 'logoutGuestUser',
			'EvCheckout.Controller.Order.cancel' => 'logoutGuestUser'
		);
	}

	/**
	 * queue up the confirmation emails
	 *
	 * @param 	CakeEvent
	 */
	public function logoutGuestUser(CakeEvent $Event) {
		// Event subject will be the OrdersController

		if ((bool)$Event->subject()->Auth->user('User.is_guest_user') === true) {
			$Event->subject()->Auth->logout();
		}
	}
}