<?php

App::uses('EvCheckoutAppController', 'EvCheckout.Controller');

class OrderItemsController extends EvCheckoutAppController {

/**
 * Override the EvCoreController level adminActions to only allow
 * the admin user to access one method in the Controller
 */
	public $adminActions = array(
		'admin_update_statuses'
	);

/**
 * Updates the order item statuses based on the supplied request data array
 *
 * @return redirects the user back to the referring url
 */
	public function admin_update_statuses() {
		$OrderItem = $this->{$this->modelClass};

		if (! empty($this->request->data[$OrderItem->alias])) {
			if ($OrderItem->saveMany($this->request->data[$OrderItem->alias])) {
				// order item statuses updated, report to the user
				$this->Flash->success(array(
						'title' => 'Order Item Status Updated',
						'description' => 'The requested order item statues have been saved'
					)
				);

				// trigger the status update success hook
				$this->getEventManager()->dispatch(
					new CakeEvent('EvCheckout.Controller.OrderItems.statusChanged', $this, array(
						'OrderItem' => $this->request->data[$OrderItem->alias]
					))
				);
			} else {
				$this->Flash->fail(array(
						'title' => 'Order Item Status Save Failed',
						'description' => 'An error occurred attempting to save the order item statuses. Please check and try again'
					)
				);
			}
		}

		return $this->redirect($this->referer());
	}

}
