<?php

$config = array(
	'EvCheckout' => array(
		/**
		 * pageIds for success / fail pages
		 */
		'pageIds' => array(
			'success' => null,
			'fail' => null,
			'cancel' => null
		),

		/**
		 * Set this to enable the multi edit dispatch action
		 */
		//'dispatchedStatusId' => 4,

		/**
		 * will this checkout allow guest checkout
		 */
		'guestCheckout' => true,

		/**
		 * the order builder to use
		 *
		 */
		'orderBuilder' => 'EvCheckout.BasketBuilder',

		/**
		 * Swallow the VAT for Non-EU customers
		 * Setting this to true means the end user will get charged the same price as being in
		 * the EU but the shop doesn't pay VAT.
		 * If you are using this flag you should not sure VAT in the checkout as it will cause
		 * confusion for people outside the EU
		 * Note: It is based on their delivery address, not billing.
		 */
		'swallowVatOutsideEU' => true,

		/**
		 * Remove the VAT for Non-EU customers in its entirety
		 * Setting this to true means results in all VAT being removed for order items
		 * and order totals
		 * Note: It is based on their delivery address, not billing.
		 */
		'removeVatOutsideEU' => false,

		/**
		 * default stage process to use
		 *
		 * can be overriden with a session
		 */
		'stageProcess' => 'default',

		/**
		 * define all the stages needed during checkout
		 * the key to each stage array will be used in the url
		 *
		 * pre - array of controller methods to run on displaying the page
		 * post - array of controller methods to run when the form has been submitted
		 * template - the template to load
		 *
		 */
		/*
			Example:
			'default' => array(
				'login' => array(
					'pre' => array(
						'alreadyLoggedIn'
					),
					'post' => array(
						'processRegister',
						'processLogin'
					),
					'template' => 'Checkout/login'
				),
				'delivery-address' => array(
					'pre' => array(
						'authUser',
						'loadAddresses'
					),
					'post' => array(
						'processDeliveryAddress'
					),
					'template' => 'Checkout/delivery_address'
				),
				'confirm' => array(
					'pre' => array(
						'authUser',
						'loadSelectedAddresses',
						'processBasketShippingFromAddress',
						'processBasketVATFromAddress',
						'loadBasket'
					),
					'post' => array(
						'buildTransactionFromBasket'
					),
					'template' => 'Checkout/basket_confirm'
				)
			)
		*/
		'stages' => array(
			'default' => array()
		),

		/**
		 * BelongsTo Relationships for the OrderItem to dynamically load
		 * So we can nicely contain the data on the order page
		 */
		'OrderItemBelongsTo' => array(
		),

		/**
		 * Sub Contains for the Order Item - allows you to customise
		 * the data that is retrieve for a line item.
		 * If empty will default to all the BelongsTo Relationships
		*/
		'OrderItemContains' => array(
		),

		/**
		 * Order Item to store. Can be auto calculate from basket items rows.
		 * model is element key - sub array contains key of name and value Hash path syntax to find data
		 */
		'OrderItemData' => array(
			'EvShop.Variant' => array(
				'sku' => 'Variant.sku'
			)
		),

		/**
		 * routes for use within the templates incase any overriding takes place
		 */
		'route' => array(
			'Checkout' => array(
				'controller' => 'ev_checkout.checkout',
				'action' => 'index',
				'plugin' => 'EvCheckout'
			),
			'Order' => array(
				'controller' => 'ev_checkout.orders',
				'action' => 'index',
				'plugin' => 'EvCheckout'
			)
		),

		/**
		 * Specify whether order items can have their own, independant, order statuses
		 */
		'allowOrderItemStatuses' => false,

		/**
		 * Specify whether order items can be returned. This marks items as returned in the CMS and updates
		 * the stock when possible. Set to true to activate.
		 */
		'allowReturningItems' => false,

		/**
		 *  Assign email templates to statuses
		 */
		/* Example:
			'statusUpdateEmails' => array(
				'Paid' => array(
					array(
						'target' => 'user',
						'emailTemplate' => 'EvCheckoutStatusUpdateCustomerPaid',
						'viewTemplates' => array(
							'EvCheckout.Emails/html/Orders/orderDeliveryAddress',
							'EvCheckout.Emails/html/Orders/orderTable'
						),
						'tokens' => array(
							'customerName' => 'Order.name',
							'orderNumber' => 'Order.id'
						)
					),
					array(
						'target' => 'admin',
						'emailTemplate' => 'EvCheckoutStatusUpdateAdminPaid',
						'viewTemplates' => array(
							'EvCheckout.Emails/html/Orders/orderDeliveryAddress',
							'EvCheckout.Emails/html/Orders/orderTable',
							'EvCheckout.Emails/html/Orders/orderAdminLink'
						),
						'tokens' => array(
							'customerName' => 'Order.name',
							'orderNumber' => 'Order.id'
						)
					)
				),
				'Shipped' => array(
					array(
						'target' => 'user',
						'emailTemplate' => 'EvCheckoutStatusUpdateCustomerShipped',
						'viewTemplates' => array(
							'EvCheckout.Emails/html/Orders/orderDeliveryAddress'
						),
						'tokens' => array(
							'customerName' => 'Order.name',
							'orderNumber' => 'Order.id'
						),
						'cc' => [
							'james.hall@evoluted.net'
						],
						'bcc' => [
							'james.hall@evoluted.net'
						],
						'helpers' => array(
							'InflectorExt',
							'EvShop.Products'
						)
					)
				)
			)
		*/

		'orderEmailHelpers' => array(), // Add any additional helpers you want to access in the order email templates

		'failedOrder' => array(
			'redirect' => false,
			'message' => false,
		),

		'useSeparateOrderNotes' => false, //Set to true to have order notes treated separately.
	)
);
