<?php
class AddingOrderNotesTable extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'adding_order_notes_table';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_table' => array(
				'ev_checkout_order_notes' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
					'order_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false),
					'user_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'note' => array('type' => 'text', 'null' => true, 'default' => null, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
					'is_admin_note' => array('type' => 'boolean', 'null' => false, 'default' => 1),
					'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
						'fk_ev_checkout_order_notes_ev_checkout_orders_idx' => array('column' => 'order_id', 'unique' => 0),
						'fk_ev_checkout_order_notes_ev_core_users_idx' => array('column' => 'user_id', 'unique' => 0),
					),
					'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_general_ci', 'engine' => 'InnoDB'),
				),
			),
		),
		'down' => array(
			'drop_table' => array(
				'ev_checkout_order_notes',
			)
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}

}
