# EvCheckout

## Installation

Simply add EvCheckout to the `install.php` file within the Config directory and run `Console/cake installer core` once you have added all the other plugins you will need.

If this has already been run, simply run `Console/cake installer plugin EvCheckout `.

The installer will automatically setup the database tables, add a link within the admin to view orders, setup templates for success, fail, cancelled order pages and writes the ID numbers to an `ev_checkout.php` config. It finally then adds in some default order statuses along with some site settings.

## How it works

The checkout plugin works on the concept of "stages" for the main checkout process, with each stage being made up of a template and then `PreStage` and `PostStage` methods which are called to make each stage function. This should allow for a totally customisable checkout process for each and every site. The process works by making sure each stage submits a form back to itself, the stage handler will take care of the processing from then on.

The `PreStage` methods are called on every page load of that stage, the stage will load the list of items and loop through in order to process. If a single method returns false the stage is aborted and it will go back one stage.

The `PostStage` methods are called upon POSTing to a stage. These are then used to check the submitted data, if a single method returns false then that stage is reloaded from the beginning allowing you to go back and show things such as validation errors. If every stage returns true, the system will try to get the next Stage and redirect to it, in the event the current stage is the last one it will redirect to an Order success page instead.

Upon completion of the last stage as defined by the config, `EvCheckout` will load the order success page upon which the order is built and saved into the system. To improve flexibility the concept of `OrderBuilders` was introduced.

The `OrderBuilder` is defined within a config and is essentially a class which is run by `EvCheckout` upon an order being completed, with the class essentially building and saving the order. This concept was introduced to allow this Checkout plugin be used in various ways, simply be creating a new class to turn a membership subscription request into a valid order and actually create the subscription (for example). Built in is an OrderBuilder to transform an `EvBasket` basket into a full Order.

The checkout process also triggers various events at the end of a checkout process allowing you to hook into these events to add extra functionality. It will also send out admin and user email notifications of the order, using the Queue plugin in doing so.

## Setup

Once the installer has run and the config file generated, there are a few config items needing setting up.

The first is `stages`, this will be an associative array defining all the stages that need to be run for this process, the template it should use and all the Pre / Post Stage methods.

You can also define multiple processes within this array should the checkout have a standard checkout and a 1 page checkout setup.

The following is a default example which starts with a login / register page combo, delivery address selection page and finally a confirmation page. All the templates are relative to `/Plugin/EvCheckout/View` or `/app/View/Plugin/EvCheckout` in the event of overridden templates.

	'stages' => array(
		// this is the name of stage, for use when setting the default stage to use or switching processes
		'default' => array(
			// key is the name of this stage and is used in the url /checkout/stage/login
			'login' => array(
				// any PreStage methods to run, this checks to see if they are logged in
				// if so we can skip this stage
				'pre' => array(
					'alreadyLoggedIn'
				),
				// define the PostStage methods to run, this will check if we are registering
				// or logging in and process accordingly.
				'post' => array(
					'processRegister',
					'processLogin'
				),
				// define the template we wish to use
				'template' => 'Checkout/login'
			),
			// checkout/stage/delivery-address
			'delivery-address' => array(
				// PreStage - check we are logged in, and load all the users addresses if so
				'pre' => array(
					'authUser',
					'loadAddresses'
				),
				// PostStage - process delivery addresses, either creating new one or selecting 
				// an existing address
				'post' => array(
					'processDeliveryAddress'
				),
				'template' => 'Checkout/delivery_address'
			),
			// checkout/stage/confirm
			'confirm' => array(
				// PreStage - check the user is logged in, load the selected addresses
				// Auto process the users shipping now we have loaded the address
				// Reload the basket to show confirmation page
				'pre' => array(
					'authUser',
					'loadSelectedAddresses',
					'processBasketShippingFromAddress',
					'loadBasket'
				),
				// PostStage - We need to punch out to Paypal so build up the transaction from 
				// a basket row and send to Paypal
				'post' => array(
					'buildTransactionFromBasket'
				),
				'template' => 'Checkout/basket_confirm'
			)
		)
	),

The second attribute to define will be the default process to use if none are defined within the URL / session. `stageProcess` holds the default process to use which itself is labeled 'default' so amend if you change your process name from above.

The third attribute to define is the order builder to use. These are defined in PluginName.OrderBuilderName format. These are located either at `/app/Lib/OrderBuilder/OrderBuilderName.php` or `/Plugin/PluginName/Lib/OrderBuilder/OrderBuilderName.php`

A fourth optional parameter you can configure (more exist but are self explanatory) is `orderItemData`. The attribute allows you to define an extra data the order needs to try and save. Using the Basket Builder as an example, when saving the basket into an Order we are only able to store the basic details of name, unit prices, quantity etc... In some cases you may wish to store extra data such as the SKU or the weight / dimensions of an item and save this on the order in the event that the details eventually changed.

This is defined in the format of having the model name as the array key and the value being a sub array containing a label and the Hash path Syntax to retrieve that data.

The following example is from Brighton Tools and is used to retrieve the SKU code for each variant when we transform it into an Order.

	'orderItemData' => array(
		'EvShop.Variant' => array(
			'sku' => 'Variant.sku'
		)
	),
	
## Usage

To get started on the checkout process you can simply redirect the customer to `/checkout/`, either via the string or the routing array 
	
	array(
		'plugin' => 'ev_checkout',
		'controller' => 'checkout',
		'action' => 'index'
	);
	
Then make sure each stage contains a form which posts to itself and the stage handler will take care of the rest.

When using the `OrderBuilder` as described below, there is an `OrderManager` Component available which can be used to perform a range of actions from setting up and creating an order to marking the order as paid and triggering the events associated with that.

Bundled is also an Order History section that can be used on the front end as an extension to the my account section that comes with EvCore. This can be linked with the address management functionality bundled with EvAddressBook.

## OrderBuilder

To create an OrderBuilder simply create a class at the following location `/app/Lib/OrderBuilder` with the class name matching the filename as per CakePHP standards.

* MyBuilder -> /app/Lib/OrderBuilder/MyBuilder.php

The class should extend the base order builder and implement the `OrderBuilderInterface`, this ensures your Order Builder will have all the methods needed to run correctly. 

Below is an example class to get started.

	<?php

	App::uses('OrderBuilderInterface', 'EvCheckout.Lib');
	App::uses('OrderBuilder', 'EvCheckout.Lib');

	class MyBuilder extends OrderBuilder implements OrderBuilderInterface {

		/**
		 * build an order from a basket
		 *
		 * @param 	int 	$transactionId The successful transaction ID just completed
		 * @return  int 	$orderId 			The id number of the order we just created
		 */
		public function build($transactionId) { }
	}
	
The builder method is the one which the Order Processor will attempt to load when trying to build up the order. As part of the base `OrderBuilder` class the constructor for it automatically loads up the Controller from which called it (usually `OrdersController`) and also it will initiate and load the `OrderManager` Component and make it available at `$this->_controller->OrderManager` from within the builder allowing you to build the checkout into an actual Order.


## PreStage Methods

Below is a list of the built in available `PreStage` methods.

### alreadyLoggedIn

Used to check if the customer is already logged in, automatically redirects the user to the next stage if so

### authUser

Used to protect that stage from used that are not yet logged in.

### loadAddresses

Used with `EvAddressBook`. Loads all a logged in users stored address and sets to template so they can select an existing address without adding a new one.

Used in conjunction with PostStage - processDeliveryAddress / processBillingAddress(TBC)

### processBasketShippingFromAddress

Used with `EvBasket` and `EvShipping`. Used to calculate the shipping based on the users basket and the selected delivery address

### loadBasket

Used with `EvBasket`. Loads a users basket for use on a confirm page.

### loadSelectedAddresses

Load the saved addresses within the session `EvCheckout.address`, for displaying on the page.

## PostStage Methods

Below is a list of the built in available `PostStage ` methods.

### processRegister

Used to process a new users registration. Can handle full registration or guest checkout

### processLogin

Used to login an existing user

### processDeliveryAddress

Used to process a delivery address, either by selecting an existing one or adding a new one and then selecting it.

Used with `EvAddressBook` and the PreStage method - loadAddresses

### buildTransactionFromBasket

Used in conjunction with `EvBasket`, `EvAddressBook` and `EvTransactions`. This gets the basket and selected addresses and passes it all to `EvTransactions` Component and the `takePayment()` method. This will either redirect off site to Paypal type gateway or potentially return to the method for the checkout handler to process the redirecting to the success page.

## Sessions

### EvCheckout.stageProcess

A session can be set with this name with the contents of the session being the key of one of the stage processes from the EvCheckout Config.

This should allow things like a custom admin process to be run.

Upon completion of any Checkouts in that scenario remember to delete the session

### EvCheckout.address

A session set to hold to the selected delivery / billing address ID numbers (used in conjunction with EvAddressBook).

* EvCheckout.address.delivery - contains the id selected for delivery address
* EvCheckout.address.billing - contains the id selected for billing address

## Events

### EvCheckout.Component.Order.paid

Called by the OrderManager component when an order has been marked as paid

#### Parameters

* `orderId` - The order that has been marked as paid

### EvCheckout.Component.Order.statusChanged

Called by the OrderManager component when an orders status has been updated

#### Parameters

* `orderId` - The order that has been updated
* `statusId` - The new order status id

### EvCheckout.Controller.Order.success

Called by OrderController::complete() when an order was successfully processed

#### Parameters

* `orderId` - The order that has been created

### EvCheckout.Controller.Order.fail

Called by OrderController::complete() when an order failed to process

#### Parameters

No parameters passed

### EvCheckout.Controller.Order.cancel

Called by OrderController::cancel() when an order was cancelled

#### Parameters

No parameters passed