<div class="container">
	<div class="row pad-bottom">
		<div class="col-xs-12">
			<h2>Order #<?=$order['Order']['id']?></h2>
		</div>
	</div>

	<div class="row pad-bottom">
		<div class="col-xs-6">
			<p>
				Ordered: <?=$this->Time->format("jS M Y g:ia", $order['Order']['created'])?><br>
				Name: <?=$order['Order']['name']?><br>
				Email: <?=$this->Text->autoLinkEmails($order['Order']['email'])?><br>

				<?php if (! empty($order['Order']['phone'])):?>
					Phone: <?=$order['Order']['phone']?><br>
				<?php endif; ?>

				Status: <?=$order['OrderStatus']['name']?><br>

				<?php if (isset($order['Order']['is_paid']) && $order['Order']['is_paid']): ?>
					<br>
					<span class="label label-default">ORDER PAID</span>
				<?php endif; ?>
			</p>
		</div>

		<div class="col-xs-">
			<p><strong>Delivery Address</strong></p>

			<?=$order['Order']['delivery_address']?>
		</div>
	</div>

	<br><br>

	<table class="table table-bordered table-striped" style="margin: 0px 10px !important; width: 99% !important;">
		<thead>
			<tr>
				<th>Item</th>
				<th>Price</th>
				<th>Quantity</th>
				<th class="basket__total">Total</th>
			</tr>
		</thead>

		<tbody>
			<?php if (! empty($order['OrderItem'])): ?>
				<?php foreach ($order['OrderItem'] as $Item): ?>
					<tr>
						<td>
							<?=$Item['name']?><br>
							<?php if (! empty($Item['OrderItemData'])): ?>
								<?php foreach ($Item['OrderItemData'] as $label => $value): ?>
									[<?=$label?>: <?=$value?>]
								<?php endforeach; ?>
							<?php endif; ?>
						</td>
						<td><?=$this->Number->currency($Item['unit_price'], $currencyList[$order['Order']['currency_id']])?></td>
						<td><?=$Item['quantity']?></td>
						<td class="basket__total">
							<?=$this->Number->currency($Item['row_total'], $currencyList[$order['Order']['currency_id']])?>
						</td>
					</tr>
				<?php endforeach; ?>
			<?php endif; ?>
		</tbody>

		<tfoot>
			<?php if (! empty($order['OrderTotal'])): ?>
				<?php foreach ($order['OrderTotal'] as $Total): ?>
					<tr>
						<td colspan="3" class="text--right">
							<strong><?=$Total['name']?></strong>
						</td>
						<td class="basket__total">
						<?=$this->Number->currency($Total['amount'], $currencyList[$order['Order']['currency_id']])?>
						</td>
					</tr>
				<?php endforeach; ?>
			<?php endif; ?>
		</tfoot>
	</table>

</div>
