<p>A new order has been made by <?=$order['Order']['name']?>.</p>

<p>The order number is (#<?=$order['Order']['id']?>). See below for confirmation of what they have ordered.</p>

<?php if (! empty($order['Order']['delivery_address'])): ?>
	<p>
		<b>Delivery Address</b><br>
		<?=$order['Order']['delivery_address']?>
	</p>
<?php endif; ?>

<table class="results" style="margin: 0px !important; width: 100% !important;">
	<thead>
		<tr style="background-color: #363636;color:#fff;">
			<th align="left">Item</th>
			<th align="left">Price</th>
			<th align="left">Quantity</th>
			<th align="left">Total</th>
		</tr>
	</thead>

	<tbody>
		<?php if (! empty($order['OrderItem'])): ?>
			<?php foreach ($order['OrderItem'] as $Item): ?>
				<tr>
					<td>
						<?=$Item['name']?>
					</td>
					<td><?=$this->Number->currency($Item['unit_price'], $currencyList[$order['Order']['currency_id']])?></td>
					<td><?=$Item['quantity']?></td>
					<td class="basket__total">
						<?=$this->Number->currency($Item['row_total'], $currencyList[$order['Order']['currency_id']])?>
					</td>
				</tr>
			<?php endforeach; ?>
		<?php endif; ?>
	</tbody>

	<tfoot>
		<?php if (! empty($order['OrderTotal'])): ?>
			<?php foreach ($order['OrderTotal'] as $Total): ?>
				<tr>
					<td colspan="3" align="right">
						<strong><?=$Total['name']?></strong>
					</td>
					<td align="left">
						<?=$this->Number->currency($Total['amount'], $currencyList[$order['Order']['currency_id']])?>
					</td>
				</tr>
			<?php endforeach; ?>
		<?php endif; ?>
	</tfoot>
</table>
<br><br>
<?=$this->Html->link(__('Manage Order'), $manageOrderUrl)?>
