<?php
//Get the tracking ID
if(!isset($trackingCode)):
	$trackingCode = Configure::read('SiteSetting.general.google_analytics');
endif;

if($trackingCode && Configure::read('app.environment') !== 'DEVELOPMENT'): ?>
<script type="text/javascript">

	var _gaq = _gaq || [];
	_gaq.push(['_setAccount', '<?=$trackingCode?>']);
	_gaq.push(['_trackPageview']);
	_gaq.push(['_addTrans',
		'<?=$completeOrder['Order']['id']?>', 		// transaction ID - required
		'<?=Configure::read('SiteSetting.general.site_title')?>',
		'<?=$orderTotal?>'							// total - required
	]);

	<?php if (! empty($completeOrder['OrderItem'])): ?>
		<?php foreach ($completeOrder['OrderItem'] as $Item): ?>
			<?php
				if (! empty($Item['OrderItemData']['sku'])):
					$sku = $Item['OrderItemData']['sku'];
				else:
					$sku = $Item['id'];
				endif;
			?>
			_gaq.push(['_addItem',
				'<?=$completeOrder['Order']['id']?>', 		// transaction ID - required
				'<?=$sku?>',           // SKU/code - required
				'<?=$Item['name']?>',        // product name
				'',
				'<?=number_format($Item['unit_price'], 2, '.', '')?>',          // unit price - required
				'<?=$Item['quantity']?>'               // quantity - required
			]);
		<?php endforeach; ?>
	<?php endif; ?>

	_gaq.push(['_trackTrans']); //submits transaction to the Analytics servers

	(function() {
	  var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
	  ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
	  var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
	})();

</script>
<?php endif; ?>
