<?php
/**
 * OrderItem Fixture
 */
class OrderItemFixture extends CakeTestFixture {

	public $table = 'ev_checkout_order_items';

/**
 * Fields
 *
 * @var array
 */
	public $fields = array(
		'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'primary'),
		'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
		'quantity' => array('type' => 'integer', 'null' => true, 'default' => null, 'length' => 10, 'unsigned' => false),
		'unit_price' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '12,6', 'unsigned' => false),
		'row_total' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '12,6', 'unsigned' => false),
		'tax_rate' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '6,2', 'unsigned' => false),
		'order_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'index'),
		'is_active' => array('type' => 'boolean', 'null' => true, 'default' => '0'),
		'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
		'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
		'indexes' => array(
			'PRIMARY' => array('column' => 'id', 'unique' => 1),
			'fk_order_items_orders1_idx' => array('column' => 'order_id', 'unique' => 0)
		),
		'tableParameters' => array('charset' => 'utf8mb4', 'collate' => 'utf8mb4_general_ci', 'engine' => 'InnoDB')
	);

/**
 * Records
 *
 * @var array
 */
	public $records = array(
		array(
			'id' => 1,
			'name' => 'Lorem ipsum dolor sit amet',
			'quantity' => 1,
			'unit_price' => '',
			'row_total' => '',
			'tax_rate' => '',
			'order_id' => 1,
			'is_active' => 1,
			'created' => '2015-08-24 11:08:03',
			'modified' => '2015-08-24 11:08:03'
		),
	);

}
