<?php
App::uses('EvCheckoutAppModel', 'EvCheckout.Model');
/**
 * OrderStatus Model
 *
 * @property Order $Order
 */
class OrderStatus extends EvCheckoutAppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'name';

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'name' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				'message' => 'Status must be filled in'
			),
		),
	);

	//The Associations below have been created with all possible keys, those that are not needed can be removed

/**
 * hasMany associations
 *
 * @var array
 */
	public $hasMany = array(
		'Order' => array(
			'className' => 'EvCheckout.Order'
		)
	);

	/**
	 * set constants to define unpaid / paid statuses
	 */
	const
		UNPAID = 1,
		PAID = 2;
}
