<?php
App::uses('EvCheckoutAppModel', 'EvCheckout.Model');

/**
 * Order Model
 *
 * @property OrderStatus $OrderStatus
 * @property OrderItem $OrderItem
 * @property OrderTotal $OrderTotal
 */
class Order extends EvCheckoutAppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'name';

/**
 * inject currency details
 * @var array
 */
	public $actsAs = array(
		'EvCurrency.Currency' => array(
			'formInject' => true
		)
	);

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'name' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
		'email' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
			'email' => array(
				'rule' => array('email'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
		'order_status_id' => array(
			'numeric' => array(
				'rule' => array('numeric'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
	);

	//The Associations below have been created with all possible keys, those that are not needed can be removed

/**
 * belongsTo associations
 *
 * @var array
 */
	public $belongsTo = array(
		'OrderStatus' => array(
			'className' => 'EvCheckout.OrderStatus'
		),
		'Currency' => array(
			'className' => 'EvCurrency.Currency'
		)
	);

/**
 * hasMany associations
 *
 * @var array
 */
	public $hasMany = array(
		'OrderItem' => array(
			'className' => 'EvCheckout.OrderItem'
		),
		'OrderTotal' => array(
			'className' => 'EvCheckout.OrderTotal'
		),
		'OrderUpdate' => array(
			'className' => 'EvCheckout.OrderUpdate'
		)
	);

	/**
	 * update the order, marking it as paid
	 *
	 * @param 	int 	$orderId 	The order ID to update
	 * @return 	bool
	 */
	public function paid($orderId) {
		$OrderStatus = EvClassRegistry::init('EvCheckout.OrderStatus');

		return $this->save(
			array(
				'Order' => array(
					'id' => $orderId,
					'is_paid' => 1,
					'order_status_id' => $OrderStatus->getConstant('PAID')
				)
			)
		);
	}

	/**
	 * update the order, amended order status
	 *
	 * @param 	int 	$orderId 	The order ID to update
	 * @param 	int 	$statusId 	The status ID to set
	 * @return 	bool
	 */
	public function updateStatus($orderId, $statusId) {
		return $this->save(
			array(
				'Order' => array(
					'id' => $orderId,
					'order_status_id' => $statusId
				)
			)
		);
	}

	/**
	 * redefine the readForView
	 *
	 * @param integer $id ID of row to edit
	 * @param array $params The db query array - can be used to pass in additional parameters such as contain
	 * @return array
	 */
	public function readForEdit($id, $params = array()) {
		$params['contain']['OrderItem'] = array(
			'OrderItemData'
		);
		$params['contain']['OrderTotal'] = array(
			'order' => 'OrderTotal.sequence ASC'
		);
		$params['contain'][] = 'OrderStatus';

		return parent::readForEdit($id, $params);
	}

	/**
	 * redefine the readForView
	 *
	 * @param integer $id ID of row to edit
	 * @param array $params The db query array - can be used to pass in additional parameters such as contain
	 * @return array
	 */
	public function readForView($id, $params = array()) {
		$params['contain']['OrderItem'] = array(
			'OrderItemData'
		);
		$params['contain']['OrderTotal'] = array(
			'order' => 'OrderTotal.sequence ASC'
		);
		$params['contain'][] = 'OrderStatus';

		return parent::readForView($id, $params);
	}

	/**
	 * afterFind to transform the transactionData
	 * into easier to use format
	 *
	 * @param mixed $results The results of the find operation
	 * @param bool $primary Whether this model is being queried directly (vs. being queried as an association)
	 * @return mixed Result of the find operation
	 * @link http://book.cakephp.org/2.0/en/models/callback-methods.html#afterfind
	 */
	public function afterFind($results, $primary = false) {
		if (isset($results['0']['OrderItem']['0']['OrderItemData'])) {
			foreach ($results as $key => $order) {
				foreach ($order['OrderItem'] as $itemKey => $item) {
					$results[$key]['OrderItem'][$itemKey]['OrderItemData'] = Hash::combine(
						$results[$key]['OrderItem'][$itemKey]['OrderItemData'],
						'{n}.name',
						'{n}.item_data'
					);
				}
			}
		}

		return $results;
	}

	/**
	 * Executed before a save() operation.
	 *
	 * @param $Model
	 * @param array $options
	 * @return  boolean
	 */
	public function beforeSave($options = array()) {
		# If we're editing an existing object, save off a copy of
		# the object as it exists before any changes.
		if (!empty( $this->id )) {
			$this->_original = $this->find('first', array(
				'conditions' => array(
					'id' => $this->id
				)
			));
		}
		return parent::beforeSave($options);
	}

	public function afterSave($created, $options = array()) {
		// We are looking for changes so don't do anything if created
		if (!$created) {
			// Get the updated version of the model
			$data = $this->find('first', array(
				'conditions' => array(
					'id' => $this->id
				)
			));

			// Compare the order_status_id with the before save version
			if ($data['Order']['order_status_id'] != $this->_original['Order']['order_status_id']) {
				// The order status has been updated so log the change
				$this->OrderUpdate->create();

				$orderUpdate = array(
					'OrderUpdate' => array(
						'order_id' => $this->id,
						'field' => 'order_status_id',
						'previous_value' => $this->_original['Order']['order_status_id'],
						'new_value' => $data['Order']['order_status_id']
					)
				);

				$this->OrderUpdate->save($orderUpdate);
			}
		}

		return parent::afterSave($created, $options);
	}

}
