<?php

App::uses('PluginInstallShell', 'shells');
App::uses('File', 'Utility');

class EvCheckoutInstallShell extends PluginInstallShell {

	public $uses = array(
		'EvTemplates.Template',
		'EvCore.Page',
		'EvCheckout.OrderStatus',
		'EvNavigation.Menu',
		'EvSiteSettings.SiteSetting',
		'EvSiteSettings.SiteSettingCategory'
	);

	/**
	 * call parent run() This will auto run any migrations
	 *
	 * Use the run() method here to insert any content
	 */
	public function run() {
		parent::run();

		$this->Menu->save(
			array(
				'Menu' => array(
					'parent_id' => 1,
					'name' => 'Orders',
					'pattern' => '/^\/admin\/ev_checkout\//',
					'plugin' => 'EvCheckout',
					'controller' => 'ev_checkout.orders',
					'model' => 'Order',
					'action' => 'index',
					'class' => 'icon-gbp',
					'is_active' => 1
				)
			)
		);

		$date = date('Y-m-d H:i:s');

		// add all the base temoplates
		$this->Template->saveMany(
			array(
				array(
					'Template' => array(
						'name' => 'Order Successful',
						'template' => 'EvCheckout./Templates/Order/successful',
						'helperFunction' => 'N/A',
						'cfDataLabel' => 'Custom Data',
						'model' => 'Page',
						'is_active' => 1,
						'created' => $date,
						'modified' => $date
					)
				),
				array(
					'Template' => array(
						'name' => 'Order Failed',
						'template' => 'EvCheckout./Templates/Order/fail',
						'helperFunction' => 'N/A',
						'cfDataLabel' => 'Custom Data',
						'model' => 'Page',
						'is_active' => 1,
						'created' => $date,
						'modified' => $date
					)
				),
				array(
					'Template' => array(
						'name' => 'Order Cancelled',
						'template' => 'EvCheckout./Templates/Order/cancelled',
						'helperFunction' => 'N/A',
						'cfDataLabel' => 'Custom Data',
						'model' => 'Page',
						'is_active' => 1,
						'created' => $date,
						'modified' => $date
					)
				)
			)
		);
		$templateIds = $this->Template->find('list', array('callbacks' => false, 'limit' => 3, 'order' => 'Template.id DESC'));
		$templateIds = array_flip($templateIds);

		// add the pages for the index
		$this->Page->saveMany(
			array(
				array(
					'Page' => array(
						'title' => 'Order Successful',
						'body' => '<p>Your order (#ORDERID) was placed successfully. You shall receive a confirmation email shortly.</p>',
						'is_active' => 1,
						'is_protected' => 1,
						'template_id' => $templateIds['Order Successful'],
						'created' => $date,
						'modified' => $date
					)
				),
				array(
					'Page' => array(
						'title' => 'Order Failed',
						'body' => '<p>There was a problem completing your order, please try again. If the problem persists, please contact us.</p>',
						'is_active' => 1,
						'is_protected' => 1,
						'template_id' => $templateIds['Order Failed'],
						'created' => $date,
						'modified' => $date
					)
				),
				array(
					'Page' => array(
						'title' => 'Order Cancelled',
						'body' => '<p>The checkout process was cancelled.</p>',
						'is_active' => 1,
						'is_protected' => 1,
						'template_id' => $templateIds['Order Cancelled'],
						'created' => $date,
						'modified' => $date
					)
				)
			)
		);
		$pageIds = $this->Page->find('list', array('callbacks' => false, 'limit' => 3, 'order' => 'Page.id DESC'));
		$pageIds = array_flip($pageIds);

		// write to the plugin config
		$configContents = '<?php

$config = array(
	\'EvCheckout\' => array(
		/**
		 * pageIds for success / fail pages
		 */
		\'pageIds\' => array(
			\'success\' => ' . $pageIds['Order Successful'] . ',
			\'fail\' => ' . $pageIds['Order Failed'] . ',
			\'cancel\' => ' . $pageIds['Order Cancelled'] . '
		)
	)
);';

		$File = new File(APP . 'Config/Plugin/ev_checkout.php', true);
		$File->write($configContents);

		$this->OrderStatus->saveMany(
			array(
				array(
					'OrderStatus' => array(
						'name' => 'Awaiting Payment',
						'sequence' => 10,
						'is_active' => 1,
						'created' => $date,
						'modified' => $date
					)
				),
				array(
					'OrderStatus' => array(
						'name' => 'Paid',
						'sequence' => 20,
						'is_active' => 1,
						'created' => $date,
						'modified' => $date
					)
				),
				array(
					'OrderStatus' => array(
						'name' => 'Shipped',
						'sequence' => 30,
						'is_active' => 1,
						'created' => $date,
						'modified' => $date
					)
				)
			)
		);

		$Category = $this->SiteSettingCategory->save(
			array(
				'SiteSettingCategory' => array(
					'name' => 'Checkout',
					'array_slug' => 'ev_checkout',
					'sequence' => 0,
					'prevent_edit' => 0
				)
			)
		);

		$this->SiteSetting->saveMany(
			array(
				array(
					'name' => 'New Order Notification Email',
					'array_slug' => 'new_order_email',
					'value' => 'admin@evoluted.net',
					'type' => 'string',
					'sequence' => 0,
					'site_setting_category_id' => $this->SiteSettingCategory->id,
					'prevent_edit' => 0
				),
				array(
					'name' => 'New Order Notification Name',
					'array_slug' => 'new_order_name',
					'value' => 'Admin',
					'type' => 'string',
					'sequence' => 0,
					'site_setting_category_id' => $this->SiteSettingCategory->id,
					'prevent_edit' => 0
				),
				array(
					'name' => 'Enable Adwords Conversion Tracking?',
					'array_slug' => 'enable_conversion_tracking',
					'value' => '1',
					'type' => 'boolean',
					'sequence' => 0,
					'site_setting_category_id' => $this->SiteSettingCategory->id,
					'prevent_edit' => 0
				),
				array(
					'name' => 'Adwords Conversion ID',
					'array_slug' => 'google_conversion_id',
					'value' => '',
					'type' => 'string',
					'sequence' => 0,
					'site_setting_category_id' => $this->SiteSettingCategory->id,
					'prevent_edit' => 0
				),
				array(
					'name' => 'Adwords Conversion Label',
					'array_slug' => 'google_conversion_label',
					'value' => '',
					'type' => 'string',
					'sequence' => 0,
					'site_setting_category_id' => $this->SiteSettingCategory->id,
					'prevent_edit' => 0
				),
			)
		);
	}
}
