<h2>Order History</h2>

<?php
	//debug($orders['0']);

?>

<table class="table table-bordered table-striped">
	<thead>
		<tr>
			<th>#</th>
			<th>Order Date</th>
			<th>Status</th>
			<th>Amount</th>
			<th>View</th>
		</tr>
	</thead>

	<tbody>
		<?php
			$baseUrl = $this->Route->getItemRoute('EvCheckout', 'Order');
			$baseUrl['action'] = 'view';

			$totalLabel = Configure::read('EvBasket.labels.grandtotal');
			if (empty($totalLabel)):
				$totalLabel = 'Total';
			endif;
		?>
		<?php foreach ($orders as $order): ?>
			<tr>
				<td><?=$order['Order']['id']?></td>
				<td><?=$this->Time->format("jS M Y g:ia", $order['Order']['created'])?></td>
				<td><?=$order['OrderStatus']['name']?></td>
				<td>
					<?php
						foreach ($order['OrderTotal'] as $total):
							if ($total['name'] == $totalLabel):
								echo $this->Number->currency($total['amount']);
							endif;
						endforeach;
					?>
				</td>
				<td>
				<?php
					$viewOrderUrl = $baseUrl;
					$viewOrderUrl[] = $order['Order']['id'];

					echo $this->Html->link(
						'View Order <i class="fa fa-chevron-right"></i>',
						$viewOrderUrl,
						array(
							'escape' => false
						)
					);
				?>
				</td>
			</tr>
		<?php endforeach; ?>
	</tbody>
</table>

<?=$this->element('EvCheckout.paginate')?>
