<div class="container">
	<div class="row pad-bottom">
		<div class="col-xs-12">
			<h1><?=Configure::read('SiteSetting.general.site_title')?> Invoice</h1>

			<h2>Order #<?=$this->request->data['Order']['id']?></h2>
		</div>
	</div>

	<div class="row pad-bottom">
		<div class="col-xs-4">
			<?=Configure::read('SiteSetting.contact.address')?>
		</div>

		<div class="col-xs-4">
			<p>
				Ordered: <?=$this->Time->format("jS M Y g:ia", $this->request->data['Order']['created'])?><br>
				Name: <?=$this->request->data['Order']['name']?><br>
				Email: <?=$this->Text->autoLinkEmails($this->request->data['Order']['email'])?><br>

				<?php if (! empty($this->request->data['Order']['phone'])):?>
					Phone: <?=$this->request->data['Order']['phone']?><br>
				<?php endif; ?>

				<?php if (isset($this->request->data['Order']['is_paid']) && $this->request->data['Order']['is_paid']): ?>
					<br>
					<span class="label label-default">ORDER PAID</span>
				<?php endif; ?>
			</p>
		</div>

		<div class="col-xs-4">
			<p><strong>Delivery Address</strong></p>

			<?=$this->request->data['Order']['delivery_address']?>
		</div>
	</div>

	<table class="table table-bordered table-striped" style="margin: 0px 10px !important; width: 99% !important;">
		<thead>
			<tr>
				<th>Item</th>
				<th>Price</th>
				<th>Quantity</th>
				<th class="basket__total">Total</th>
			</tr>
		</thead>

		<tbody>
			<?php if (! empty($this->request->data['OrderItem'])): ?>
				<?php foreach ($this->request->data['OrderItem'] as $Item): ?>
					<tr>
						<td>
							<?=$Item['name']?><br>
							<?php if (! empty($Item['OrderItemData'])): ?>
								<?php foreach ($Item['OrderItemData'] as $label => $value): ?>
									[<?=$label?>: <?=$value?>]
								<?php endforeach; ?>
							<?php endif; ?>
						</td>
						<td><?=$this->Number->currency($Item['unit_price'], 'GBP')?></td>
						<td><?=$Item['quantity']?></td>
						<td class="basket__total">
							<?=$this->Number->currency($Item['row_total'], 'GBP')?>
						</td>
					</tr>
				<?php endforeach; ?>
			<?php endif; ?>
		</tbody>

		<tfoot>
			<?php if (! empty($this->request->data['OrderTotal'])): ?>
				<?php foreach ($this->request->data['OrderTotal'] as $Total): ?>
					<tr>
						<td colspan="3" class="text--right">
							<strong><?=$Total['name']?></strong>
						</td>
						<td class="basket__total">
						<?=$this->Number->currency($Total['amount'], 'GBP')?>
						</td>
					</tr>
				<?php endforeach; ?>
			<?php endif; ?>
		</tfoot>
	</table>

</div>

<?php
	echo $this->Html->scriptBlock("
		window.print()
	");


