<div class='edit-form'>

	<div class='edit-form__header'>
		<h1 class='title'><?php echo $this->InflectorExt->camelToPluralize($displayName); ?> <span>Administration</span></h1>
		<h2 class='title edit-form__title'>
			Manage Order
		</h2>

		<?php echo $this->Element('toolbar'); ?>
		<div class="tab-container"></div>
	</div>

	<?php

		echo $this->Html->script(
			array(
				'admin_form',
				'attachments',
				'tinymce/js/tinymce/tinymce.min',
				'map_location'
			),
			array('inline'=>false)
		);
	?>
	<div class="cr page-body">
		<div class="container-fluid">
			<div class="row">

				<div class="col-md-3">
					<div class="panel panel-default">
						<div class="panel-heading">
							<h3 class="panel-title">Details</h3>
						</div>
						<div class="panel-body">
							Order #<?=$this->request->data['Order']['id']?><br>
							Status: <?=$this->request->data['OrderStatus']['name']?><br>
							Name: <?=$this->request->data['Order']['name']?><br>
							Email: <?=$this->Text->autoLinkEmails($this->request->data['Order']['email'])?><br>

							<?php if (! empty($this->request->data['Order']['phone'])):?>
								Phone: <?=$this->request->data['Order']['phone']?><br>
							<?php endif; ?>

							<?php if (isset($this->request->data['Order']['is_guest_checkout']) && $this->request->data['Order']['is_guest_checkout']): ?>
								<span class="label label-danger">Guest Checkout</span><br>
							<?php endif; ?>

							<?php if (isset($this->request->data['Order']['is_paid']) && $this->request->data['Order']['is_paid']): ?>
								<span class="label label-success">ORDER PAID</span>
							<?php endif; ?>
						</div>
					</div>
				</div>

				<?php if (! empty($this->request->data['Order']['billing_address'])): ?>
					<div class="col-md-3">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h3 class="panel-title">Billing Address</h3>
							</div>
							<div class="panel-body">
								<?=$this->request->data['Order']['billing_address']?>
							</div>
						</div>
					</div>
				<?php endif; ?>
				<?php if (! empty($this->request->data['Order']['delivery_address'])): ?>
					<div class="col-md-3">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h3 class="panel-title">Delivery Address</h3>
							</div>
							<div class="panel-body">
								<?=$this->request->data['Order']['delivery_address']?>
							</div>
						</div>
					</div>
				<?php endif; ?>

				<div class="col-md-3">
					<div class="panel panel-default">
						<div class="panel-heading">
							<h3 class="panel-title">Actions</h3>
						</div>
						<div class="panel-body">
							<?php if (! isset($this->request->data['Order']['is_paid']) || ! $this->request->data['Order']['is_paid']): ?>
								<?php
									echo $this->Form->create(
										$primaryModel,
										array(
											'url' => array(
												'action' => 'pay',
											)
										)
									);
										echo $this->Form->button(
											__('Mark as Paid'),
											array(
												'class' => 'btn btn-danger',
												'onclick' => "return confirm('Are you sure?');"
											)
										);

									echo $this->Form->end();
								?>
								<br>
								<hr>
							<?php endif; ?>

							<?php
								echo $this->Form->create(
									$primaryModel,
									array(
										'url' => array(
											'action' => 'status',
										),
										'onsubmit' => "return confirm('Are you sure?');"
									)
								);

									echo $this->Form->addField(
										'Order.order_status_id',
										array(
											'type' => 'select',
											'div' => false,
											'label' => false
										)
									);

									echo $this->Form->button(
										__('Change Status'),
										array(
											'class' => 'btn btn-danger change-status'
										)
									);

								echo $this->Form->end();

								$printUrl = $this->Route->getItemRoute('EvCheckout', 'Order');
								$printUrl['action'] = 'invoice';
								$printUrl['admin'] = true;
								$printUrl[] = $this->request->data['Order']['id'];

								echo '<br>' . $this->Html->link(
									'Print Invoice',
									$printUrl,
									array(
										'escape' => false,
										'class' => 'btn btn-info',
										'target' => '_blank'
									)
								);
							?>

						</div>
					</div>
				</div>

			</div>
		</div>

		<table class="results" style="margin: 0px 10px !important; width: 99% !important;">
			<thead>
				<tr>
					<th>Item</th>
					<th>Price</th>
					<th>Quantity</th>
					<th class="basket__total">Total</th>
				</tr>
			</thead>

			<tbody>
				<?php if (! empty($this->request->data['OrderItem'])): ?>
					<?php foreach ($this->request->data['OrderItem'] as $Item): ?>
						<tr>
							<td>
								<?=$Item['name']?><br>
								<?php if (! empty($Item['OrderItemData'])): ?>
									<?php foreach ($Item['OrderItemData'] as $label => $value): ?>
										[<?=$label?>: <?=$value?>]
									<?php endforeach; ?>
								<?php endif; ?>
							</td>
							<td><?=$this->Number->currency($Item['unit_price'], 'GBP')?></td>
							<td><?=$Item['quantity']?></td>
							<td class="basket__total">
								<?=$this->Number->currency($Item['row_total'], 'GBP')?>
							</td>
						</tr>
					<?php endforeach; ?>
				<?php endif; ?>
			</tbody>

			<tfoot>
				<?php if (! empty($this->request->data['OrderTotal'])): ?>
					<?php foreach ($this->request->data['OrderTotal'] as $Total): ?>
						<tr>
							<td colspan="3" class="text--right">
								<strong><?=$Total['name']?></strong>
							</td>
							<td class="basket__total">
							<?=$this->Number->currency($Total['amount'], 'GBP')?>
							</td>
						</tr>
					<?php endforeach; ?>
				<?php endif; ?>
			</tfoot>
		</table>

	</div>
</div>