<?php
App::uses('EvCheckoutAppModel', 'EvCheckout.Model');

/**
 * Order Model
 *
 * @property OrderStatus $OrderStatus
 * @property OrderItem $OrderItem
 * @property OrderTotal $OrderTotal
 */
class Order extends EvCheckoutAppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'name';

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'name' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
		'email' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
			'email' => array(
				'rule' => array('email'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
		'order_status_id' => array(
			'numeric' => array(
				'rule' => array('numeric'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
	);

	//The Associations below have been created with all possible keys, those that are not needed can be removed

/**
 * belongsTo associations
 *
 * @var array
 */
	public $belongsTo = array(
		'OrderStatus' => array(
			'className' => 'EvCheckout.OrderStatus'
		)
	);

/**
 * hasMany associations
 *
 * @var array
 */
	public $hasMany = array(
		'OrderItem' => array(
			'className' => 'EvCheckout.OrderItem'
		),
		'OrderTotal' => array(
			'className' => 'EvCheckout.OrderTotal'
		)
	);

	/**
	 * update the order, marking it as paid
	 *
	 * @param 	int 	$orderId 	The order ID to update
	 * @return 	bool
	 */
	public function paid($orderId) {
		$OrderStatus = EvClassRegistry::init('EvCheckout.OrderStatus');

		return $this->save(
			array(
				'Order' => array(
					'id' => $orderId,
					'is_paid' => 1,
					'order_status_id' => $OrderStatus->getConstant('PAID')
				)
			)
		);
	}

	/**
	 * update the order, amended order status
	 *
	 * @param 	int 	$orderId 	The order ID to update
	 * @param 	int 	$statusId 	The status ID to set
	 * @return 	bool
	 */
	public function updateStatus($orderId, $statusId) {
		return $this->save(
			array(
				'Order' => array(
					'id' => $orderId,
					'order_status_id' => $statusId
				)
			)
		);
	}

	/**
	 * redefine the readForView
	 *
	 * @param integer $id ID of row to edit
	 * @param array $params The db query array - can be used to pass in additional parameters such as contain
	 * @return array
	 */
	public function readForEdit($id, $params = array()) {
		$params['contain']['OrderItem'] = array(
			'OrderItemData'
		);
		$params['contain']['OrderTotal'] = array(
			'order' => 'OrderTotal.sequence ASC'
		);
		$params['contain'][] = 'OrderStatus';

		return parent::readForEdit($id, $params);
	}

	/**
	 * redefine the readForView
	 *
	 * @param integer $id ID of row to edit
	 * @param array $params The db query array - can be used to pass in additional parameters such as contain
	 * @return array
	 */
	public function readForView($id, $params = array()) {
		$params['contain']['OrderItem'] = array(
			'OrderItemData'
		);
		$params['contain']['OrderTotal'] = array(
			'order' => 'OrderTotal.sequence ASC'
		);
		$params['contain'][] = 'OrderStatus';

		return parent::readForView($id, $params);
	}

	/**
	 * afterFind to transform the transactionData
	 * into easier to use format
	 *
	 * @param mixed $results The results of the find operation
	 * @param bool $primary Whether this model is being queried directly (vs. being queried as an association)
	 * @return mixed Result of the find operation
	 * @link http://book.cakephp.org/2.0/en/models/callback-methods.html#afterfind
	 */
	public function afterFind($results, $primary = false) {
		if (isset($results['0']['OrderItem']['0']['OrderItemData'])) {
			foreach ($results as $key => $order) {
				foreach ($order['OrderItem'] as $itemKey => $item) {
					$results[$key]['OrderItem'][$itemKey]['OrderItemData'] = Hash::combine(
						$results[$key]['OrderItem'][$itemKey]['OrderItemData'],
						'{n}.name',
						'{n}.item_data'
					);
				}
			}
		}

		return $results;
	}
}
