<?php

App::uses('CakeEventListener', 'Event');
App::uses('CakePlugin', 'Core');

class AddSuccessfulOrderTemplate implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'EvCheckout.Controller.Order.success' => 'addOrderToTemplate'
		);
	}

	/**
	 * queue up the confirmation emails
	 *
	 * @param 	CakeEvent
	 */
	public function addOrderToTemplate(CakeEvent $Event) {
		// 'orderId' should be set in data
		if (empty($Event->data['orderId'])) {
			return false;
		}

		$Order = EvClassRegistry::init('EvCheckout.Order');
		$details = $Order->readForEdit($Event->data['orderId']);

		$Event->subject()->set(
			'completeOrder',
			$details
		);

		if (CakePlugin::loaded('EvBasket') && ! empty($details['OrderTotal'])) {
			$totalLabel = Configure::read('EvBasket.labels.grandtotal');

			if (empty($totalLabel)) {
				$totalLabel = 'Total';
			}

			foreach ($details['OrderTotal'] as $total) {
				if ($total['name'] == $totalLabel) {
					$Event->subject()->set(
						'orderTotal',
						number_format($total['amount'], 2, '.', '')
					);
				}
			}
		}

		return true;
	}
}
