<?php

$config = array(
	'EvCheckout' => array(
		/**
		 * pageIds for success / fail pages
		 */
		'pageIds' => array(
			'success' => null,
			'fail' => null,
			'cancel' => null
		),

		/**
		 * will this checkout allow guest checkout
		 */
		'guestCheckout' => true,

		/**
		 * the order builder to use
		 *
		 */
		'orderBuilder' => 'EvCheckout.BasketBuilder',

		/**
		 * default stage process to use
		 *
		 * can be overriden with a session
		 */
		'stageProcess' => 'default',

		/**
		 * define all the stages needed during checkout
		 * the key to each stage array will be used in the url
		 *
		 * pre - array of controller methods to run on displaying the page
		 * post - array of controller methods to run when the form has been submitted
		 * template - the template to load
		 *
		 */
		/*
			Example:
			'default' => array(
				'login' => array(
					'pre' => array(
						'alreadyLoggedIn'
					),
					'post' => array(
						'processRegister',
						'processLogin'
					),
					'template' => 'Checkout/login'
				),
				'delivery-address' => array(
					'pre' => array(
						'authUser',
						'loadAddresses'
					),
					'post' => array(
						'processDeliveryAddress'
					),
					'template' => 'Checkout/delivery_address'
				),
				'confirm' => array(
					'pre' => array(
						'authUser',
						'loadSelectedAddresses',
						'processBasketShippingFromAddress',
						'loadBasket'
					),
					'post' => array(
						'buildTransactionFromBasket'
					),
					'template' => 'Checkout/basket_confirm'
				)
			)
		*/
		'stages' => array(
			'default' => array()
		),

		/**
		 * Order Item to store. Can be auto calculate from basket items rows.
		 * model is element key - sub array contains key of name and value Hash path syntax to find data
		 */
		'orderItemData' => array(
			'EvShop.Variant' => array(
				'sku' => 'Variant.sku'
			)
		),

		/**
		 * routes for use within the templates incase any overriding takes place
		 */
		'route' => array(
			'Checkout' => array(
				'controller' => 'ev_checkout.checkout',
				'action' => 'index',
				'plugin' => 'EvCheckout'
			),
			'Order' => array(
				'controller' => 'ev_checkout.orders',
				'action' => 'index',
				'plugin' => 'EvCheckout'
			)
		)
	)
);