<?php
$this->assign('title', __('Checkout'));
?>
<div class="row">
	
	<ul class='arrow-breadcrumbs arrow-breadcrumbs--4-items'>
		<li class='arrow-breadcrumbs__item'>
			<i class="fa fa-user"></i> Personal Details/Login
		</li>

		<li class='arrow-breadcrumbs__item active'>
			<div class='arrow-breadcrumbs__spacer'>&nbsp;</div>
			<i class="fa fa-truck"></i> Delivery Address
		</li>

		<li class='arrow-breadcrumbs__item'>
			<div class='arrow-breadcrumbs__spacer'>&nbsp;</div>
			<i class="fa fa-credit-card"></i> Pay & Confirm
		</li>

		<li class='arrow-breadcrumbs__item'>
			<div class='arrow-breadcrumbs__spacer'>&nbsp;</div>
			<i class="fa fa-check"></i> Order Complete
		</li>
	</ul>

</div>	
 
<div class='row'>
	<div class='col-10'>
		<h1>Pay & Confirm</h1>
		
		<!-- jQuery adds up the totals, although it can be easily stripped out -->
		<div class='basket basketSummation'>
			<table>
				<tr>
					<th>Item</th>
					<th>In Stock</th>
					<th>Options</th>
					<th>Price</th>
					<th>Quantity</th>
					<th class='basket__total'>Total</th>
				</tr>

				<?php foreach($cart['OrderItem'] as $cartItem): ?>

					<tr>
						<td><?php echo $cartItem['name']; ?></td>
						<td><div class='color--green'><i class='fa fa-check'></i> In Stock</div></td>
						<td><?php echo $cartItem['description']; ?></td>
						<td><?php echo $this->Number->currency($cartItem['unit_cost']); ?></td>
						<td><?php echo $cartItem['quantity']; ?></td>
						<td class='basket__total' data-cost='399.99'><?php echo $this->Number->currency($cartItem['subtotal']); ?></td>
					</tr>

				<?php endforeach; ?>

			</table>

			<div class='basket__totals match-heights'>
				<div class='basket__delivery'>
					<i class='fa fa-truck'></i>
					<p>Delivery</p>
					<p class='small'>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent id lacus posuere, luctus nunc vitae, elementum elit. Vestibulum eu libero lectus. Proin sed congue enim, dignissim vulputate tortor. Praesent arcu neque, porta non magna iaculis, auctor accumsan ipsum.</p>
				</div>
				<div class='basket__totals__right match-heights'>
					<table>
						<tr>
							<td><strong>Sub total</strong></td>
							<td class='basket__total basketSummation__subtotal'><?php echo $this->Number->currency($cart['Order']['subtotal']); ?></td>
						</tr>
						<tr>
							<td><strong>Delivery</strong></td>
							<td class='basket__total' data-cost='20.00'><?php echo $this->Number->currency($cart['Order']['delivery_subtotal']); ?></td>
						</tr>
						<tr>
							<td><strong>VAT</strong></td>
							<td class='basket__total basketSummation__subtotal'><?php echo $this->Number->currency($cart['Order']['vat']); ?></td>
						</tr>
						<tr>
							<td><strong>Total</strong></td>
							<td class='basket__total basketSummation__total'><?php echo $this->Number->currency($cart['Order']['total']); ?></td>
						</tr>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>

<?php echo $this->Form->create('Order', array('class' => 'form--rounded_fields')); ?>

<div class='row'> 
	<div class="match-height-set">
		<div class="col-5 matching-height-set__0">
			<fieldset>
				<legend>Delivery Address</legend>
						<?php 
							echo $this->Form->addField('DeliveryAddress.address_line_1', array(
								'type' => 'string', 
								'label' => 'Address line 1'
							));
						?>

						<?php 
							echo $this->Form->addField('DeliveryAddress.address_line_2', array(
								'type' => 'string',
								'label' => 'Address line 2'
							));
						?>

						<?php 
							echo $this->Form->addField('DeliveryAddress.address_line_3', array(
								'type' => 'string', 
								'label' => 'City / Town'
							));
						?>

						<?php 
							echo $this->Form->addField('DeliveryAddress.county', array(
								'type' => 'string'
							));
						?>

						<?php 
							echo $this->Form->addField('DeliveryAddress.country', array(
								'type' => 'hidden'
							));
						?>

						<?php 
							echo $this->Form->addField('DeliveryAddress.postcode', array(
								'type' => 'string', 
							));
						?>


			</fieldset>
		</div>

		<div class="col-5 matching-height-set__0">
			<fieldset>
				<legend>Invoice Address</legend>

				<?php 
					echo $this->Form->addField('InvoiceAddress.match_delivery_address', array(
						'type' => 'boolean', 
						'label' => 'Same as Delivery Address'
					));
				?>

				<?php 
					echo $this->Form->addField('InvoiceAddress.address_line_1', array(
						'type' => 'string', 
						'label' => 'Address line 1'
					));
				?>

				<?php 
					echo $this->Form->addField('InvoiceAddress.address_line_2', array(
						'type' => 'string',
						'label' => 'Address line 2'
					));
				?>

				<?php 
					echo $this->Form->addField('InvoiceAddress.address_line_3', array(
						'type' => 'string', 
						'label' => 'City / Town'
					));
				?>

				<?php 
					echo $this->Form->addField('InvoiceAddress.county', array(
						'type' => 'string'
					));
				?>

				<?php 
					echo $this->Form->addField('InvoiceAddress.country', array(
						'type' => 'hidden'
					));
				?>

				<?php 
					echo $this->Form->addField('InvoiceAddress.postcode', array(
						'type' => 'string', 
					));
				?>


			</fieldset>
		</div>
		
	</div>
</div>


<div class='row'> 
	<div class="match-height-set">
		

		<div class="col-5 matching-height-set__0">
			<fieldset>
				<legend>Card Details</legend>


				<?php 
					echo $this->Form->addField('CreditCard.name', array(
						'type' => 'string', 
						'label' => 'Card Holder Name'
					));
				?>

				<?php 
					// echo $this->Form->addField('CreditCard.type', array(
					// 	'type' => 'select',
					// 	'label' => 'Card Type', 
					// 	'options' => array(
					// 		'1' => 'Visa Credit', 
					// 		'2' => 'Visa Debit'
					// 	)
					// ));
				?>

				<?php 
					echo $this->Form->addField('CreditCard.card_number', array(
						'type' => 'string', 
						'label' => 'Card Number'
					));
				?>

				<?php 
					echo $this->Form->addField('CreditCard.security_number', array(
						'type' => 'string', 
						'label' => 'Security Number', 
						'div' => 'input input--small'
					));
				?>

				<div class="input date">

					<label>Expiry Date</label>
					
					<?php 
						echo $this->Form->addField('CreditCard.expiry_month', array(
							'type' => 'select', 
							'label' => false, 
							// 'div' => false, 
							'div' => 'input select input--small input--inline', 
							'empty' => 'MM'
						));
					?>

					<?php 
						echo $this->Form->addField('CreditCard.expiry_year', array(
							'type' => 'select', 
							'label' => false, 
							// 'div' => false, 
							'div' => 'input select input--small input--inline', 
							'empty' => 'YY'
						));
					?>

				</div>

				<div class="input date">

					<label>Start Date</label>
					
					<?php 
						echo $this->Form->addField('CreditCard.start_month', array(
							'type' => 'select', 
							'label' => false, 
							// 'div' => false, 
							'div' => 'input select input--small input--inline', 
							'empty' => 'MM'
						));
					?>

					<?php 
						echo $this->Form->addField('CreditCard.start_year', array(
							'type' => 'select', 
							'label' => false, 
							// 'div' => false, 
							'div' => 'input select input--small input--inline', 
							'empty' => 'YY'
						));
					?>

				</div>

				<?php 
					echo $this->Form->addField('CreditCard.issue_number', array(
						'type' => 'string', 
						'label' => 'Issue Number', 
						'div' => 'input input--small'
					));
				?>


			</fieldset>
		</div>
	</div>
</div>

<div class="input submit right">
	<label>&nbsp;</label>
	<?php
		echo $this->Form->button('Pay & Confirm Order <i class="fa fa-caret-right"></i>',
			array( 
				'escape' => false
			)
		);
	?>
</div>

<?php echo $this->Form->end(); ?>
