<?php $this->Extend('/Scaffolds/admin_form'); ?>
<?php $this->Append('additionalFormTabs'); ?>

	<div class='tab__content' data-title='Order Details'>
		<?php echo $this->Element('EvCheckout.tabs/order_summary', array('cart' => $this->request->data)); ?>
	</div>

<?php $this->end(); //Block.additionalFormTabs end ?>

<!-- Main tab -->
<?php

	echo $this->Form->addField('Order.id', array(
		'type' => 'hidden'
	));

	echo $this->Html->tag('div', null, array('class' => 'field'));
	echo $this->Html->tag('div', __('Order Reference'), array('class' => 'field__label'));
	echo $this->Html->tag('div', $this->request->data['Order']['invoice_number'], array('class' => 'field__value'));
	echo $this->Html->tag('/div');

	echo $this->Html->tag('div', null, array('class' => 'field'));
	echo $this->Html->tag('div', __('Paid'), array('class' => 'field__label'));
	echo $this->Html->tag('div', $this->request->data['Order']['is_paid'] ? __('Yes') : __('No'), array('class' => 'field__value'));
	echo $this->Html->tag('/div');

	echo $this->Form->addField(
		'Order.order_status_id', 
		array('type' => 'select'), 
		array('label' => __('Order Status'))
	);
?>

<div class="field">
	<div class="field__label">Customer</div>
	<div class="field__value">
		<?php 
			if ($this->request->data['Order']['user_id'] > 0) {
				echo $this->Html->link(
					$this->request->data['Order']['full_name'], 
					array(
						'controller' => 'users', 
						'action' => 'edit', 
						$this->request->data['Order']['user_id']
					)
				);
			} else {
				echo $this->request->data['Order']['full_name'];
			}
		?>
	</div>
</div>
<div class="field">
	<div class="field__label">Email</div>
	<div class="field__value">
		<?php 
			echo $this->Text->autoLinkEmails($this->request->data['Order']['email']);
		?>
	</div>
</div>
<?php 
	echo $this->Form->addField(
		'Customer.phone', 
		array(
			'type' => 'string',
			'label' => 'Telephone',
			'displayonly' => true
		)
	);
?>

<?php echo $this->Form->addField('Order.processed_by', array('type' => 'string')); ?>		

<div class="field">
	<div class="field__label">Payment Method</div>
	<div class="field__value"><?php echo Inflector::humanize($this->request->data['Transaction']['payment_method']); ?></div>
</div>

<?php 
	echo $this->Form->addField(
		'Order.order_time', 
		array(
			'type' => 'datetime',
			'displayonly' => true
		)
); ?>

<div class="field">
	<div class="field__label">Order Total</div>
	<div class="field__value">
		<?php echo $this->Number->currency($this->request->data['Order']['total']); ?>
	</div>
</div>