<?php
/**
 * Helper for easily rendering an address in a View template.
 * 
 * e.g. echo $this->CustomerAddress->format($data['CustomerAddress']);
 */

App::uses('AppHelper', 'View/Helper');

class CustomerAddressHelper extends AppHelper {

	public $helpers = array('Html');

/**
 * Returns a formatted address excluding empty address fields.
 * 
 * @param array $data array containing the address
 * @param array $attributes options
 * @return string
 */
	public function format($data, $attributes = array()) {

		$defaults = array(
			'tag' => 'address'
		);

		$attributes = array_merge($defaults, $attributes);

		$fields = array(
			array(
				'house_number',
				'address_line_1'
			),
			'address_line_2',
			'address_line_3',
			'city',
			'county',
			'postcode'
		);

		$address = array();

		foreach ($fields as $field) {

			if (is_array($field)) {

				$line = array();

				foreach ($field as $item) {
					if (!empty($data[$item])) {
						$line[] = $data[$item];
					}
				}

				$address[] = implode(', ', $line);

			} else {

				if (!empty($data[$field])) {
					$address[] = $data[$field];
				}

			}

		}

		$formattedAddress = implode('<br />', $address);

		if (!empty($attributes['tag'])) {
			$tag = $attributes['tag'];
			unset($attributes['tag']);
			$formattedAddress = $this->Html->tag($tag, $formattedAddress, $attributes);
		}

		return $formattedAddress;

	}

}