<?php 
	
	//Set variable defaults
	$editable = isset($editable) ? $editable : false; 
	$delivery_info = isset($delivery_info) ? $delivery_info : true; 
	$stock_column = isset($stock_column) ? $stock_column : true; 

	echo $this->Form->create();

?>
<div class='basket basketSummation'>
	<table>
		<tr>
			<th>Item</th>
			<?php if ($stock_column): ?>
				<th>In Stock</th>
			<?php endif; ?>
			<th>Options</th>
			<th>Price</th>
			<th>Quantity</th>
			<th class='basket__total'>Total</th>
		</tr>

		<?php foreach ($cart['OrderItem'] as $cartItem): ?>

			<tr>
				<td>
					<?php 
						if (!empty($cartItem['product_id'])) {
							echo $this->Html->link(
								$cartItem['name'], 
								array('controller' => 'products', 'action' => 'view', $cartItem['product_id'])
							);
						} else {
							echo $cartItem['name'];
						}
					?>
				</td>
				<?php if ($stock_column): ?>
					<td>In Stock</td>
				<?php endif; ?>
				<td><?php echo $cartItem['description']; ?></td>
				<td><?php echo $this->Number->currency($cartItem['unit_cost']); ?></td>
				<td>
				<?php
					if ($editable===true) {
						echo $this->Form->input(
							'OrderItem.' . $cartItem['id'] . '.id', 
							array( 
								'value' => $cartItem['id']
							)
						);
						echo $this->Form->input(
							'OrderItem.' . $cartItem['id'] . '.quantity', 
							array(
								'type' => 'number', 
								'value' => $cartItem['quantity'], 
								'label' => false,
								'onchange' => 'this.form.submit()'
							)
						);
						echo ' ';
						echo $this->Html->link(
							'(remove)', 
							array(
								'action' => 'remove_item', 
								$cartItem['id']
							),
							array(
								'escape' => false
							)
						);
					} else {
						echo $cartItem['quantity'];
					}

				?>
				</td>
				<td class='basket__total' data-cost='<?php echo $cartItem['subtotal']; ?>'><?php echo $this->Number->currency($cartItem['subtotal']); ?></td>
			</tr>

		<?php endforeach; ?>

	</table>

	<div class='basket__totals match-heights'>
		<?php if($delivery_info && Configure::read('SiteSetting.delivery_info')): ?>
			<div class='basket__delivery'>
				<i class='fa fa-truck'></i>
				<p>Delivery</p>
				<p class='small'><?php echo Configure::read('SiteSetting.delivery_info'); ?></p>
			</div>
		<?php endif; ?>
		<div class='basket__totals__right match-heights'>
			<table>
				<tr>
					<td><strong>Sub total</strong></td>
					<td class='basket__total basketSummation__subtotal'><?php echo $this->Number->currency($cart['Order']['subtotal']); ?></td>
				</tr>
				<?php if (!empty($cart['Order']['delivery_surcharge']) && $cart['Order']['delivery_surcharge'] > 0): ?>
					<tr>
						<td><strong>Surcharge</strong></td>
						<td class='basket__total' data-cost='20.00'><?php echo $this->Number->currency($cart['Order']['surcharge_subtotal']); ?></td>
					</tr>
				<?php endif; ?>
				<tr>
					<td><strong>Delivery</strong></td>
					<td class='basket__total' data-cost='20.00'><?php echo $this->Number->currency($cart['Order']['delivery_subtotal']); ?></td>
				</tr>
				<tr>
					<td><strong>VAT</strong></td>
					<td class='basket__total basketSummation__subtotal'><?php echo $this->Number->currency($cart['Order']['vat']); ?></td>
				</tr>
				<tr>
					<td><strong>Total</strong></td>
					<td class='basket__total basketSummation__total'><?php echo $this->Number->currency($cart['Order']['total']); ?></td>
				</tr>
			</table>
		</div>
	</div>
</div>
<?php

	echo $this->Form->end();