<?php

App::uses('EvCheckoutAppController', 'EvCheckout.Controller');
App::uses('UsersController', 'Controller');

/**
 * Customers Controller
 *
 * @package EvCheckout/Customers
 */
class CustomersController extends UsersController {

	public $uses = 'EvCheckout.Customer';

/**
 * Pagination settings for admin_index
 *
 * Override in your own controller to customise
 *
 * @return array
 */
	protected function _adminIndexPaginate() {
		$Model = $this->{$this->modelClass};

		$conditions = $this->_processFilter();

		$conditions[$Model->alias . '.user_group_id'] = $Model::CUSTOMER_USER_GROUP;

		$paginate = array(
			'conditions' => $conditions,
		);

		return $paginate;
	}

	protected function _adminFormFields() {
		$Model = $this->{$this->modelClass};
		$fields = parent::_adminFormFields();

		unset($fields['password']);
		unset($fields[$Model->alias . '.user_group_id']);
		unset($fields[$Model->alias . '.password']);
		unset($fields[$Model->alias . '.password_reset_code']);
		unset($fields[$Model->alias . '.password_reset_code_expires']);

		return $fields;
	}

/**
 * Defines the columns to display for admin_index().
 *
 * @return array
 */
	protected function _adminIndexColumns() {
		$Model = $this->{$this->modelClass};

		$columns = parent::_adminIndexColumns();

		unset($columns["UserGroup.name"]);

		return $columns;
	}

/**
 * Add or edit a user.
 *
 * @param  integer $id User ID
 */
	public function admin_edit($id = null) {
		parent::admin_edit($id);

		return;
	}

}
