<?php
$this->assign('title', __('Order Confirmation'));
?>
<div class="row">
	
	<ul class='arrow-breadcrumbs arrow-breadcrumbs--4-items'>
		<li class='arrow-breadcrumbs__item'>
			<i class="fa fa-user"></i> Personal Details/Login
		</li>

		<li class='arrow-breadcrumbs__item'>
			<div class='arrow-breadcrumbs__spacer'>&nbsp;</div>
			<i class="fa fa-truck"></i> Delivery Address
		</li>

		<li class='arrow-breadcrumbs__item'>
			<div class='arrow-breadcrumbs__spacer'>&nbsp;</div>
			<i class="fa fa-credit-card"></i> Pay & Confirm
		</li>

		<li class='arrow-breadcrumbs__item active'>
			<div class='arrow-breadcrumbs__spacer'>&nbsp;</div>
			<i class="fa fa-check"></i> Order Complete
		</li>
	</ul>

</div>

<div>
<?php
	if (!empty($data)) {
		echo $this->Html->tag('h1', $data['Page']['title']);
		echo $this->Html->para(null, __('Order Reference: %s', $cart['Order']['invoice_number']));
		echo $data['Page']['body'];
		echo $this->Html->para(null, $this->Html->link(__('Return to homepage'), '/'));
	} else {
		echo $this->Html->tag('h1', 'Thank You');
		echo $this->Html->para(null, __('Order Reference: %s', $cart['Order']['invoice_number']));
		echo $this->Html->para(null, $this->Html->link(__('Return to homepage'), '/'));
	}
?>
</div>

<?php 

	//Get the tracking ID
	if(!isset($tracking_code)) {

		$tracking_code = Configure::read('SiteSetting.google_analytics');

	}

	if(!isset($tracking_site)) {

		$site = $_SERVER['HTTP_HOST'];

	}
	
	if($tracking_code && Configure::read('app.enviroment') !== 'DEVELOPMENT') {

		$trackingJS = "";

		$siteTitle = Configure::read('SiteSetting.site_title');

		$trackingJS .= "
			ga('ecommerce:addTransaction', {
			  'id': '{$cart['Order']['invoice_number']}',
			  'affiliation': '{$siteTitle}',
			  'revenue': '{$cart['Order']['total']}',
			  'shipping': '{$cart['Order']['delivery_total']}',
			  'tax': '{$cart['Order']['vat']}'
			});
		";

		foreach($cart['OrderItem'] as $orderItem) {

			$trackingJS .= "
				ga('ecommerce:addItem', {
				  'id': '{$orderItem['id']}',
				  'name': '{$orderItem['name']}',
				  'category': '{$orderItem['description']}',
				  'price': '{$orderItem['total']}',
				  'quantity': '{$orderItem['quantity']}'
				});
			";

		}

		$trackingJS .= "ga('ecommerce:send')";

		$this->Html->scriptBlock($trackingJS, array('inline' => false)); 

	}
