<?php
	$this->assign('title', __('Invoice'));
	echo $this->Html->script('EvCheckout.checkout', array('inline' => false));
?>

<div class="row">
	
	<ul class='arrow-breadcrumbs arrow-breadcrumbs--4-items'>
		<li class='arrow-breadcrumbs__item'>
			<i class="fa fa-user"></i> Personal Details/Login
		</li>

		<li class='arrow-breadcrumbs__item'>
			<div class='arrow-breadcrumbs__spacer'>&nbsp;</div>
			<i class="fa fa-truck"></i> Delivery Address
		</li>

		<li class='arrow-breadcrumbs__item active'>
			<div class='arrow-breadcrumbs__spacer'>&nbsp;</div>
			<i class="fa fa-credit-card"></i> Pay & Confirm
		</li>

		<li class='arrow-breadcrumbs__item'>
			<div class='arrow-breadcrumbs__spacer'>&nbsp;</div>
			<i class="fa fa-check"></i> Order Complete
		</li>
	</ul>

</div>

<?php echo $this->Session->flash(); ?>
 
<div class='row'>
	<div class='col-10'>
		<h1>Pay & Confirm</h1>
		
		<?php echo $this->Element('EvCheckout.basket', array('cart' => $cart, 'editable' => false)); ?>

	</div>
</div>

<div class="row">
	<div class="col-10">
		&nbsp;
	</div>
</div>

<?php echo $this->Form->create(
	'InvoiceAddress', 
	array(
		'class' => 'form--rounded_fields', 
		'inputDefaults' => array(
			// 'error' => false
		)
	)
); ?>

<div class='row'> 
	<div class="match-height-set">
		<div class="col-5 matching-height-set__0">
			<div class="address_form">
				<fieldset>
					<legend>Invoice Address</legend>

					<?php 
						echo $this->Form->addField('InvoiceAddress.match_delivery_address', array(
							'type' => 'boolean', 
							'label' => 'Same as Delivery Address', 
							'class' => 'match_address'
						));
					?>

					<?php echo $this->Element('EvCheckout.address/address_fields', array('model' => 'InvoiceAddress')); ?>

				</fieldset>

			</div>
		</div>

		<div class="col-5 matching-height-set__0">
			<fieldset>
				<legend>Card Details</legend>


				<?php 
					echo $this->Form->addField('CreditCard.name', array(
						'type' => 'string', 
						'label' => 'Card Holder Name'
					));
				?>

				<?php 
					// echo $this->Form->addField('CreditCard.type', array(
					// 	'type' => 'select',
					// 	'label' => 'Card Type', 
					// 	'options' => array(
					// 		'1' => 'Visa Credit', 
					// 		'2' => 'Visa Debit'
					// 	)
					// ));
				?>

				<?php 
					echo $this->Form->addField('CreditCard.card_number', array(
						'type' => 'string', 
						'label' => 'Card Number'
					));
				?>

				<?php 
					echo $this->Form->addField('CreditCard.security_number', array(
						'type' => 'string', 
						'label' => 'Security Number', 
						'div' => 'input input--small'
					));
				?>

				<div class="input date">

					<label>Expiry Date</label>
					
					<?php 
						echo $this->Form->addField('CreditCard.expiry_month', array(
							'type' => 'select', 
							'label' => false, 
							// 'div' => false, 
							'div' => 'input select input--small input--inline', 
							'empty' => 'MM', 
							'error' => false
						));
					?>

					<?php 
						echo $this->Form->addField('CreditCard.expiry_year', array(
							'type' => 'select', 
							'label' => false, 
							// 'div' => false, 
							'div' => 'input select input--small input--inline', 
							'empty' => 'YY', 
							'error' => false
						));
					?>

				</div>

				<div class="input date">

					<label>Start Date</label>
					
					<?php 
						echo $this->Form->addField('CreditCard.start_month', array(
							'type' => 'select', 
							'label' => false, 
							// 'div' => false, 
							'div' => 'input select input--small input--inline', 
							'empty' => 'MM'
						));
					?>

					<?php 
						echo $this->Form->addField('CreditCard.start_year', array(
							'type' => 'select', 
							'label' => false, 
							// 'div' => false, 
							'div' => 'input select input--small input--inline', 
							'empty' => 'YY'
						));
					?>

				</div>

				<?php 
					echo $this->Form->addField('CreditCard.issue_number', array(
						'type' => 'string', 
						'label' => 'Issue Number', 
						'div' => 'input input--small'
					));
				?>


			</fieldset>
		</div>
	</div>
</div>

<div class="input submit right">
	<?php
		echo $this->Form->button('Pay & Confirm Order <i class="fa fa-caret-right"></i>',
			array( 
				'escape' => false
			)
		);
	?>
</div>

<?php echo $this->Form->end(); ?>
