<?php
App::uses('EvCheckoutAppModel', 'EvCheckout.Model');

class VatRate extends EvCheckoutAppModel {

	public $hasMany = array(
		'Product'
	);

	public $validate = array(
		'name' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Please provide a name for the VAT rate'
			)
		),
		'rate' => array(
			'numeric' => array(
				'rule' => 'numeric',
				'message' => 'Please provide a percentage rate'
			)
		)
	);

	public $findMethods = array('list' => true);

	protected function _findList($state, $query, $results = array()) {
		if ($state == 'before') {

			$query['conditions']['is_active'] = true;

			return $query;

		}

		$data = [];

		foreach ($results as $result) {

			$data[$result['VatRate']['id']] = $result['VatRate']['name'] . ' - ' . number_format($result['VatRate']['rate'], 2) . '%';

		}

		return $data;
	}

}
