<?php

App::uses('EvCheckoutAppModel', 'EvCheckout.Model');

class CreditCard extends EvCheckoutAppModel {

	public $useTable = false;

	public $validate = array(
		'name' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Please enter exactly as on card'
			)
		),
		'card_number' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Please enter a valid card number'
			),
			'cc' => array(
				'rule' => array('cc', 'all'),
				'message' => 'Please enter exactly as on card'
			)
		),
		'security_number' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Please enter a valid security number'
			),
			'numeric' => array(
				'rule' => 'numeric',
				'message' => 'Please enter exactly as on card'
			)
		),
		'expiry_month' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Please select expiry month'
			),
			'numeric' => array(
				'rule' => 'numeric',
				'message' => 'Please select expiry month'
			)
		),
		'expiry_year' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'Please select expiry year'
			),
			'numeric' => array(
				'rule' => 'numeric',
				'message' => 'Please select expiry year'
			)
		),
		'start_month' => array(
			'numeric' => array(
				'rule' => 'numeric',
				'message' => 'Please select start month',
				'allowEmpty' => true
			)
		),
		'start_year' => array(
			'numeric' => array(
				'rule' => 'numeric',
				'message' => 'Please select start year',
				'allowEmpty' => true
			)
		),
		'issue_number' => array(
			'numeric' => array(
				'rule' => 'numeric',
				'message' => 'Please enter exactly as on card',
				'allowEmpty' => true
			)
		),

	);

}
