<?php

App::uses('CakeEventListener', 'Event');

class OrderEmailListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'Model.Order.orderCreated' => 'orderCreated',
			'Model.Order.orderCompleted' => 'orderCompleted',
			'Model.Order.orderCancelled' => 'orderCancelled',
			'Model.Order.orderDispatched' => 'orderDispatched',
			'Model.Order.orderRefunded' => 'orderRefunded',
		);
	}

/**
 * Called when an order has been created.
 *
 * @return void
 */
	public function orderCreated() {
		return;
	}

/**
 * Called when an order has been paid and completed.
 *
 * @return void
 */
	public function orderCompleted(CakeEvent $event) {
		$this->emailConfirmation($event->data['data']['Order']['id']);

		return;
	}

/**
 * Called when an order has been cancelled.
 *
 * @return void
 */
	public function orderCancelled(CakeEvent $event) {
		return;
	}

/**
 * Called when an order has been dispatched.
 *
 * @return void
 */
	public function orderDispatched(CakeEvent $event) {
		return;
	}

/**
 * Called when an order has been refunded.
 *
 * @return void
 */
	public function orderRefunded(CakeEvent $event) {
		return;
	}

/**
 * Sends a confirmation email to customer and admin.
 *
 * @param integer $orderId
 * @param boolean $delayed
 * @return void
 */
	public function emailConfirmation($orderId, $delayed = false) {
		$Order = ClassRegistry::init('EvCheckout.Order');

		$order = $Order->readForEdit($orderId);

		if (!empty($order)) {

			// Send Customer email
			$Email = new CustomEmail();

			$Email->template('EvCheckout.receipt');

			$Email->to($order['Order']['email']);

			$this->_configureConfirmationEmail($Email, $order, $delayed);

			$Email->send();

			// Send Admin email
			$Email = new CustomEmail();

			$Email->template('EvCheckout.admin_receipt');

			$Email->to(Configure::read('SiteSetting.orders_email'));

			// Email addresses to copy in such as info@evoluted.net
			if (Configure::read('EvCheckout.BlindCopyEmail')) {
				$emails = explode(',', Configure::read('EvCheckout.BlindCopyEmail'));
				foreach ($emails as $emailAddress) {
					$Email->addBcc(trim($emailAddress));
				}
			}

			$this->_configureConfirmationEmail($Email, $order, $delayed);

			$Email->subject('New Order Placed on ' . Configure::read('SiteSetting.site_title'));

			$Email->send();

		}

		return;
	}

/**
 * Configures the confirmation email sent to both customers and admin.
 *
 * @param object $Email
 * @param array $order
 * @param boolean $delayed
 * @return void
 */
	protected function _configureConfirmationEmail(&$Email, $order, $delayed) {
		$Email->from(array(Configure::read('SiteSetting.admin_email') => Configure::read('SiteSetting.site_title')));
		$Email->subject(Configure::read('SiteSetting.site_title') . ' Order Confirmation');

		$Email->emailFormat('html');

		$Email->viewVars(
			array(
				'order' => $order,
				'delayed' => $delayed,
				'telephone' => Configure::read('SiteSetting.telephone_number')
			)
		);

		$Email->helpers(
			array(
				'Html',
				'Number',
				'EvCheckout.CustomerAddress'
			)
		);

		return;
	}

}
