<?php

App::uses('CakeEventListener', 'Event');

class DeliveryCalculatorListener implements CakeEventListener {

	public $defaultVatRateId = 1;

	public function implementedEvents() {
		return array(
			'Model.Order.updateOrderTotal' => 'calculateDeliveryCost',
		);
	}

/**
 * Calculate delivery costs.
 *
 * @param CakeEvent $event
 * @return array
 */
	public function calculateDeliveryCost(CakeEvent $event) {
		$orderTotal = $event->data['Order']['Order']['subtotal'] + $event->data['Order']['Order']['vat'];

		// Check if site settings allows free delivery over a given threshold
		$freeShippingThreshold = Configure::read('SiteSetting.free_delivery_threshold');
		$fixedDeliveryCost = Configure::read('SiteSetting.fixed_delivery_cost');

		// If site setting has not been set there is nothing for us to do
		if ($freeShippingThreshold !== null) {

			// Check if free shipping applies
			if ($freeShippingThreshold >= $orderTotal) {

				$deliveryCost = 0;

			} elseif ($fixedDeliveryCost !== null) {

				$deliveryCost = $fixedDeliveryCost;

			}

			// Add VAT
			$vat = 0;
			if ($this->defaultVatRateId !== null) {

				$VatRate = ClassRegistry::init('EvCheckout.VatRate');

				$vatRate = $VatRate->findById($this->defaultVatRateId);

				if ($vatRate) {

					$vat = ($vatRate[$VatRate->alias]['rate'] / 100) * $deliveryCost;

				}

			}

			// Update total
			$event->data['Order']['Order']['delivery_subtotal'] = $deliveryCost;
			$event->data['Order']['Order']['delivery_vat'] = $vat;
			$event->data['Order']['Order']['delivery_total'] = $deliveryCost + $vat;

			$event->data['Order']['Order']['total'] += $deliveryCost + $vat;
			$event->data['Order']['Order']['vat'] += $vat;

			return $event->data['Order'];
		}
	}

}
