<?php
/**
 * Order shell scripts.
 *
 * To clear out abandoned orders call:-
 *
 *   Console/cake EvCheckout.order expire {days}
 *
 * Where days is to be replaced by the number of days an order expires after.
 * For example, to expire all orders not edited in the last month call:-
 *
 *   Console/cake EvCheckout.order expire 30
 * 
 * By default it will not remove abandoned orders associated with a customer
 * containing items (so that an admin can still view these for marketing 
 * purposes). To remove them as well pass 'all' as the second argument:-
 * 
 *   Console/cake EvCheckout.order expire 30 all
 */

App::uses('CakeTime', 'Utility');
App::uses('OrderStatus', 'EvCheckout.Model');

class OrderShell extends AppShell {

	public $uses = array('EvCheckout.Order');

/**
 * Removes abandoned baskets after a given number of days. Pass 'all' as the second argument 
 * to remove all baskets including those assigned to a customer.
 */
	public function expire() {

		$deleteAfter = isset($this->args[0]) ? $this->args[0] : false;
		$deleteAfter = $deleteAfter ? intval($deleteAfter) : false;

		$deleteAll = isset($this->args[1]) && $this->args[1] == 'all';

		if ($deleteAfter===false || $deleteAfter===0) {
			$this->out("Please provide the number of days a basket expires after!");
			return false;
		}

		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		$conditions = array(
			$modelAlias . '.order_status_id' => OrderStatus::IN_BASKET,
			$modelAlias . '.modified <' => CakeTime::toServer("-{$deleteAfter} days")
		);

		if ($deleteAll === false) {
			$conditions[$modelAlias . '.user_id <>'] = 0;
			$conditions[$modelAlias . '.items_total >'] = 0;
		}

		$orders = $Model->find('list', array(
			'fields' => array($modelAlias . '.id', $modelAlias . '.order_time'),
			'conditions' => $conditions
		));

		$count = count($orders);

		if ($count) {
			// Only delete the order items we've just identified as wanting to remove.
			$conditions[$modelAlias . '.id'] = array_keys($orders);
			$Model->deleteAll($conditions);
			$this->out(__n('%d order removed', '%d orders removed', $count, $count));
		} else {
			$this->out(__('Nothing to remove'));
		}

	}

}