<?php
class SetupTables extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'Setup_tables';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_table' => array(
				'ev_checkout_customer_addresses' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
					'user_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'index'),
					'house_number' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'address_line_1' => array('type' => 'string', 'null' => false, 'default' => null, 'length' => 100, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'address_line_2' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 100, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'address_line_3' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 100, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'city' => array('type' => 'string', 'null' => false, 'default' => null, 'length' => 50, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'county' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 50, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'postcode' => array('type' => 'string', 'null' => false, 'default' => null, 'length' => 15, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'is_active' => array('type' => 'boolean', 'null' => false, 'default' => '1'),
					'last_used_for_invoice' => array('type' => 'datetime', 'null' => false, 'default' => null),
					'last_used_for_delivery' => array('type' => 'datetime', 'null' => false, 'default' => null),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
						'shop_addresses_users1_idx' => array('column' => 'user_id', 'unique' => 0),
					),
					'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_general_ci', 'engine' => 'InnoDB'),
				),
				'ev_checkout_order_items' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
					'order_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false),
					'product_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'model' => array('type' => 'string', 'null' => false, 'default' => null, 'length' => 250, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1'),
					'model_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false),
					'vat_rate_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'name' => array('type' => 'string', 'null' => false, 'default' => null, 'length' => 250, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1'),
					'description' => array('type' => 'string', 'null' => false, 'default' => null, 'length' => 250, 'collate' => 'latin1_swedish_ci', 'charset' => 'latin1'),
					'unit_cost' => array('type' => 'decimal', 'null' => false, 'default' => null, 'length' => '11,6', 'unsigned' => false),
					'quantity' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false),
					'subtotal' => array('type' => 'decimal', 'null' => false, 'default' => null, 'length' => '11,6', 'unsigned' => false),
					'vat' => array('type' => 'decimal', 'null' => false, 'default' => null, 'length' => '11,6', 'unsigned' => false),
					'total' => array('type' => 'decimal', 'null' => false, 'default' => null, 'length' => '7,2', 'unsigned' => false),
					'is_virtual' => array('type' => 'boolean', 'null' => false, 'default' => null),
					'modified' => array('type' => 'datetime', 'null' => false, 'default' => null),
					'created' => array('type' => 'datetime', 'null' => false, 'default' => null),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'latin1', 'collate' => 'latin1_swedish_ci', 'engine' => 'MyISAM'),
				),
				'ev_checkout_order_order_status_histories' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
					'order_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'order_status_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'user_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
						'id' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_general_ci', 'engine' => 'InnoDB'),
				),
				'ev_checkout_order_statuses' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
					'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'system_name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8_general_ci', 'comment' => 'Used for firing internal events e.g. shipped -> Model.Order.orderShipped', 'charset' => 'utf8'),
					'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_general_ci', 'engine' => 'InnoDB'),
				),
				'ev_checkout_orders' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
					'created' => array('type' => 'datetime', 'null' => false, 'default' => null),
					'modified' => array('type' => 'datetime', 'null' => false, 'default' => null),
					'order_time' => array('type' => 'datetime', 'null' => false, 'default' => null),
					'user_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'first_name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'last_name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'phone' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'email' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 64, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'processed_by' => array('type' => 'string', 'null' => true, 'default' => null, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'delivery_address_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false),
					'invoice_address_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false),
					'order_status_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false),
					'is_paid' => array('type' => 'boolean', 'null' => false, 'default' => '0'),
					'subtotal' => array('type' => 'decimal', 'null' => false, 'default' => null, 'length' => '11,6', 'unsigned' => false),
					'delivery_subtotal' => array('type' => 'decimal', 'null' => false, 'default' => null, 'length' => '11,6', 'unsigned' => false),
					'delivery_vat' => array('type' => 'decimal', 'null' => false, 'default' => null, 'length' => '11,6', 'unsigned' => false),
					'surcharge_subtotal' => array('type' => 'decimal', 'null' => false, 'default' => null, 'length' => '11,6', 'unsigned' => false),
					'surcharge_vat' => array('type' => 'decimal', 'null' => false, 'default' => null, 'length' => '11,6', 'unsigned' => false),
					'surcharge_total' => array('type' => 'decimal', 'null' => false, 'default' => null, 'length' => '7,2', 'unsigned' => false),
					'vat' => array('type' => 'decimal', 'null' => false, 'default' => null, 'length' => '11,6', 'unsigned' => false),
					'discount_code' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 45, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'discount_vat' => array('type' => 'decimal', 'null' => false, 'default' => '0.000000', 'length' => '11,6', 'unsigned' => false),
					'discount_total' => array('type' => 'decimal', 'null' => false, 'default' => '0.00', 'length' => '7,2', 'unsigned' => false),
					'total' => array('type' => 'decimal', 'null' => false, 'default' => null, 'length' => '7,2', 'unsigned' => false),
					'items_total' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false),
					'is_virtual' => array('type' => 'boolean', 'null' => false, 'default' => null),
					'delivery_method_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_general_ci', 'engine' => 'MyISAM'),
				),
				'ev_checkout_vat_rates' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'),
					'rate' => array('type' => 'float', 'null' => true, 'default' => null, 'unsigned' => false),
					'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'),
					'is_active' => array('type' => 'boolean', 'null' => true, 'default' => null),
					'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_general_ci', 'engine' => 'InnoDB'),
				),
			),
		),
		'down' => array(
			'drop_table' => array(
				'ev_checkout_customer_addresses', 'ev_checkout_order_items', 'ev_checkout_order_order_status_histories', 'ev_checkout_order_statuses', 'ev_checkout_orders', 'ev_checkout_vat_rates'
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {

		$OrderStatus = ClassRegistry::init('EvCheckout.OrderStatus');

		$data = array(
			array(
				'id' => 1,
				'name' => 'In Basket',
				'system_name' => 'Created'
			),
			array(
				'id' => 2,
				'name' => 'Payment Pending',
				'system_name' => 'Pending'
			),
			array(
				'id' => 3,
				'name' => 'Completed',
				'system_name' => 'Completed'
			),
			array(
				'id' => 4,
				'name' => 'Cancelled',
				'system_name' => 'Cancelled'
			),
			array(
				'id' => 5,
				'name' => 'Dispatched',
				'system_name' => 'Dispatched'
			),
			array(
				'id' => 6,
				'name' => 'Refunded',
				'system_name' => 'Refunded'
			)
		);

		
		$OrderStatus->saveMany($data);
		
		return true;
	}
}
