<?php
	$this->assign('title', __('Register'));
	echo $this->Html->css('EvCheckout.checkout', array('inline' => false));
	echo $this->Html->script('EvCheckout.checkout', array('inline' => false));
?>
<div class="row">
	
	<ul class='arrow-breadcrumbs arrow-breadcrumbs--4-items'>
		<li class='arrow-breadcrumbs__item active'>
			<i class="fa fa-user"></i> Personal Details/Login
		</li>

		<li class='arrow-breadcrumbs__item'>
			<div class='arrow-breadcrumbs__spacer'>&nbsp;</div>
			<i class="fa fa-truck"></i> Delivery Address
		</li>

		<li class='arrow-breadcrumbs__item'>
			<div class='arrow-breadcrumbs__spacer'>&nbsp;</div>
			<i class="fa fa-credit-card"></i> Pay & Confirm
		</li>

		<li class='arrow-breadcrumbs__item'>
			<div class='arrow-breadcrumbs__spacer'>&nbsp;</div>
			<i class="fa fa-check"></i> Order Complete
		</li>
	</ul>

</div>	


<div class='row'>
	<div class='col-10'>
		<h1>Personal Details / Login</h1>
	</div>
</div>

<div class='row'> 

	<div class="col-5">
		<fieldset>
			<legend>Personal Details</legend>
				
			<?php 

				echo Configure::read('SiteSetting.registration_intro');

				echo $this->Form->create('Customer', array('class' => 'form--rounded_fields'));

				echo $this->Form->radio(
					'Customer.checkout_as_guest', 
					array(
						'0' => 'Register a new account', 
						'1' => 'Guest Checkout'
					), 
					array(
						'legend' => false, 
						'default' => '0', 
						'class' => 'checkout_as_guest_checkbox'
					)
				);

				echo $this->Html->tag('h3', __('Personal Details'));
			
				echo $this->Form->addField('Customer.title', array(
					'type' => 'select', 
					'options' => array(
						'Mr' => 'Mr', 
						'Mrs' => 'Mrs', 
						'Miss' => 'Miss', 
						'Ms' => 'Ms'
					)
				));

				echo $this->Form->addField('Customer.first_name', array(
					'type' => 'string', 
				));

				echo $this->Form->addField('Customer.last_name', array(
					'type' => 'string', 
				));

				echo $this->Form->addField('Customer.phone', array(
					'type' => 'telephone', 
				));

				echo $this->Form->addField('Customer.email', array(
					'type' => 'email', 
				));


				echo $this->Html->tag('div', null, array('class' => 'register-passwords'));

				echo $this->Html->tag('h3', __('Account Details'));

				echo $this->Form->addField('Customer.password', array(
					'type' => 'password'
				));

				echo $this->Form->addField('Customer.confirm_password', array(
					'type' => 'password'
				));

				echo $this->Html->tag('/div', null); // .register-passwords

				echo $this->Form->addField('Customer.accept_terms', array(
					'type' => 'boolean',
					'format' => array('before', 'label', 'input',  'between',  'after', 'error'),
					'label' => array(
						'text' => 'I accept the '.
							$this->Html->link(
								'Terms & Conditions', 
								'/terms-and-conditions', 
								array('target' => '_blank')
							), 
						'escape' => false
					)
				));

				echo $this->Html->tag(
					'div',
					$this->Html->tag('label', '&nbsp;') . $this->Form->button(__('Register & Proceed')),
					array('class' => 'input submit')
				);

				echo $this->Form->end();

			?>

		</fieldset>
	</div>

	<div class="col-5">
		<fieldset>
			<legend>Login</legend>

			<?php

				echo $this->Html->para(null, __('If you are an existing customer please login'));

				echo $this->Form->create('User', array(
					'class' => 'form--rounded_fields',
					'url' => '/users/login'));

				echo $this->Form->addField('User.email', array(
					'type' => 'email', 
				));

				echo $this->Form->addField('User.password', array(
					'type' => 'password'
				));

				echo $this->Html->tag(
					'div',
					$this->Html->tag('label', '&nbsp;') . $this->Form->button(__('Login')),
					array('class' => 'input submit')
				);

				echo $this->Form->end();

				echo $this->Html->para(
					null,
					__(
						'If you have forgotton your password please %s',
						$this->Html->link('click here to recover it', array('controller' => 'users', 'action' => 'password_reset', 'plugin' => false))
					)
				);

			?>

		</fieldset>
	</div>

</div>