<?php

class OrderTest extends CakeTestCase {

	public $fixtures = array(
		'plugin.ev_checkout.order',
		'plugin.ev_checkout.order_item',
		'plugin.ev_checkout.order_order_status_history',
		'plugin.ev_checkout.customer_address',
		'plugin.ev_checkout.vat_rate'
	);

	public function setUp() {
		parent::setUp();
		$this->Order = ClassRegistry::init('EvCheckout.Order');
	}

	public function testAddToBasket() {
		$data = array(
			'product_id' => 1,
			'model' => 'EvShop.ProductVariant',
			'model_id' => 1,
			'order_id' => null,
			'name' => 'Test Product',
			'description' => '',
			'unit_cost' => 40.83,
			'quantity' => 1,
			'stock' => 0,
			'unlimited_stock' => true,
			'subtotal' => false,
			'vat' => false,
			'total' => false,
			'is_virtual' => false,
			'vat_rate_id' => 1
		);

		$this->Order->addToBasket($data);

		$result = $this->Order->getCart();

		// Test that item has been added to the basket.
		$this->assertCount(1, $result['OrderItem']);
		// Test subtotal correctly calculated (excludes VAT).
		$this->assertEquals(40.83, $result['Order']['subtotal']);
		// Test total correctly calculated (includes VAT).
		$this->assertEquals(49.00, $result['Order']['total']);

		$this->Order->clearCartId();

		$data['quantity'] = 2;
		$this->Order->addToBasket($data);

		$result = $this->Order->getCart();

		// Test that item has been added to the basket.
		$this->assertCount(1, $result['OrderItem']);
		// Test subtotal correctly calculated (excludes VAT).
		$this->assertEquals(81.66, $result['Order']['subtotal']);
		// Test total correctly calculated (includes VAT).
		$this->assertEquals(98.00, $result['Order']['total']);
	}

	public function testUpdateBasketItems() {
		$data = array(
			'product_id' => 1,
			'model' => 'EvShop.ProductVariant',
			'model_id' => 1,
			'order_id' => null,
			'name' => 'Test Product',
			'description' => '',
			'unit_cost' => 10.00,
			'quantity' => 1,
			'stock' => 0,
			'unlimited_stock' => true,
			'subtotal' => false,
			'vat' => false,
			'total' => false,
			'is_virtual' => false,
			'vat_rate_id' => 1
		);
		$this->Order->addToBasket($data);

		// Get basket and check that the item has been added correctly.
		$result = $this->Order->getCart();
		$this->assertEquals(10.00, $result['Order']['subtotal']);
		$this->assertEquals(1, $result['OrderItem'][0]['id']);
		// Store the unit cost inc. VAT to test after updating basket.
		$unitCostIncVat = $result['OrderItem'][0]['unit_cost_inc_vat'];

		// Check that we can increase the quantity of the item by 2 correctly.
		$data = $result;
		$data['OrderItem'][0]['quantity'] = 2;
		$this->Order->updateBasketItems($data);
		$result = $this->Order->getCart();
		$this->assertEquals(2, $result['OrderItem'][0]['quantity']);
		$this->assertEquals(20, $result['OrderItem'][0]['subtotal']);
		// Make sure the unit cost inc. VAT hasn't increased.
		$this->assertEquals($unitCostIncVat, $result['OrderItem'][0]['unit_cost_inc_vat']);

		// Remove the item and check that the basket is now empty.
		$this->Order->removeItem(1);
		$result = $this->Order->OrderItem->findByOrderId(1);
		$this->assertEmpty($result);

		// Ensure that we can't update a removed item.
		$this->Order->updateBasketItems($data);
		$result = $this->Order->OrderItem->findByOrderId(1);
		$this->assertEmpty($result);
	}

}
