<?php

App::uses('EvCheckoutAppModel', 'EvCheckout.Model');

class OrderItem extends EvCheckoutAppModel {

	public $belongsTo = array(
		'Order' => array(
			'className' => 'EvCheckout.Order',
		),
		'VatRate' => array(
			'className' => 'EvCheckout.VatRate'
		),
	);

/**
 * Construct and add in virtual fields
 */
	public function __construct($id = false, $table = null, $ds = null) {
		parent::__construct($id, $table, $ds);

		// The unit_cost excludes VAT so provide a unit_cost_inc_vat column for convinience.
		$this->virtualFields['unit_cost_inc_vat'] = 'CAST(( ' . $this->escapeField('unit_cost') . ' + ' . $this->escapeField('vat') . ' / ' . $this->escapeField('quantity') . ') AS DECIMAL(7,2))';
	}

}
