<?php

App::uses('User', 'Model');

class Customer extends User {

	public $useTable = 'users';

	public $hasMany = array(
		'Order' => array(
			'className' => 'EvCheckout.Order'
		)
	);

	const CUSTOMER_USER_GROUP = 3;

/**
 * Construct and add in virtual fields
 */
	public function __construct($id = false, $table = null, $ds = null) {
		parent::__construct($id, $table, $ds);

		$this->virtualFields['full_name'] = 'CONCAT(Customer.first_name, " ", Customer.last_name)';

		$this->validate['phone'] = array(
			'required' => array(
				'rule' => 'notEmpty'
			)
		);

		// Replace the default unique email address rule. There can be multiple
		// guest users with the same email address (to prevent someone from being
		// able to overwrite existing data without authorisation).
		$this->validate['email']['unique']['rule'] = 'uniqueEmail';
	}

	public function uniqueEmail($check) {
		if (!isset($this->data[$this->alias]['is_guest_user'])) {
			// If we've not got is_get_user we cannot validate the email address
			// so make it fail.
			return false;
		}

		if ($this->data[$this->alias]['is_guest_user'] == false) {

			$params = array(
				'conditions' => array(
					$this->alias . '.email' => array_shift($check),
					$this->alias . '.is_guest_user' => false
				)
			);

			// If we're updating a record we need to exclude it from our query.
			if (!empty($this->data[$this->alias]['id'])) {
				$params['conditions'][$this->alias . '.id <>'] = $this->data[$this->alias]['id'];
			}

			return $this->find('count', $params) === 0;

		}

		return true;
	}

	public function validateRegister() {
		$rules = $this->validate;
		$rules['accept_terms'] = array(
			'rule' => array('equalTo', '1'),
			'message' => 'Please read and accept the Terms & Conditions'
		);

		$rules['confirm_password']['required']['message'] = 'Please confirm password';

		unset($rules['user_group_id']);

		return $rules;
	}

/**
 * Handles user registration
 * @param  array $userData 	The array of new user data
 * @return int         		New User Id if success else returns false
 */
	public function register($userData) {
		$this->validate = $this->validateRegister();
		$userData[$this->alias]['user_group_id'] = self::CUSTOMER_USER_GROUP;
		$userData[$this->alias]['is_active'] = 1;

		if ($userData[$this->alias]['checkout_as_guest'] == 1) {

			unset($this->validate['email']['unique']);
			unset($this->validate['password']);
			unset($this->validate['confirm_password']);
			unset($userData[$this->alias]['password']);
			unset($userData[$this->alias]['confirm_password']);

			$this->set($userData);

			return $this->validates() ? 0 : false;

		}

		return $this->save($userData) ? $this->id : false;
	}

/**
 * Gets the user and all associated data out that is needed for login
 * @param  int $id  The ID of the user
 * @return array 	User array
 */
	public function getUserForLogin($id) {
		if ($id === 0) {

			$orderId = $this->Order->getCartId();

			$order = $this->Order->findById($orderId);

			$fullUser = array(
				'User' => array(
					'id' => 0,
					'first_name' => $order['Order']['first_name'],
					'last_name' => $order['Order']['last_name'],
					'email' => $order['Order']['email'],
					'phone' => $order['Order']['phone']
				)
			);

		} else {

			$fullUser = $this->find('first', array(
					'conditions' => array(
						$this->alias . '.id' => $id
					),
					'contain' => array(
						'UserGroup'
					)
				)
			);
			// Swap out Customer for User
			$fullUser['User'] = $fullUser['Customer'];
			unset($fullUser['Customer']);

		}

		return $fullUser;
	}

}
