<?php

/**
 *
 */

class CategorisableBehavior extends ModelBehavior {


	/**
	 * Configuration method.
	 *
	 * @param object $Model Model object
	 * @param array $config Config array
	 * @access public
	 * @return boolean
	 */
	public function setup(Model $Model, $config = array()) {

		//On setup, add the relationships
		$Model->hasAndBelongsToMany['Category'] = array(
			'className' => 'EvCategory.Category',
			'foreignKey' => 'model_id',
			'associationForeignKey' => 'category_id',
			'conditions' => array(
				'model' => $Model->name,
			),
			'with' => 'EvCategory.Categorisation',
			'dependent' => true,
			'cascade' => true, 
			'unique' => true
		);

		$Model->hasMany['Categorisation'] = array(
			'className' => 'EvCategory.Categorisation',
			'foreignKey' => 'model_id'
		);

		return true;
	}

}
