<?php

App::uses('EvCategoryAppController', 'EvCategory.Controller');

/**
 * EvCategory App Controller
 *
 * @package EvCategory
 */
class CategoriesController extends EvCategoryAppController {
	
/**
 * Set the max category children depth
 * @var integer
 */
	public $max_depth = 2; 

/**
 * Stub function
 * Used to populate form drop down selects
 *
 * Override in your controller to customise
 */
	protected function _adminPopulateLookups() {

		$Category = $this->{$this->modelClass};
		$this->set('productAttributes', $Category->ProductAttribute->find('list'));

	}

	public function admin_edit($id = null) {

		$Category = $this->{$this->modelClass};

		parent::admin_edit($id);

		// Only need to populate parents if we can have nested categories
		if ($Category->max_depth < 1) {

			$categories = $Category->find('list', array(
					'conditions' => array(
						'OR' => array(
							'parent_id' => null,
							'parent_id' => '0'
						),
						'id <>' => $id
					)
				)
			);

			$categories = array('0' => 'No Parent') + $categories;

			$this->set('parents', $categories);

		}

		return;

	}


/**
 * Defines the fields displayed in an admin_form for this model
 *
 * Defaults to all fields in the db table
 *
 * Override in your controller to customise
 */
	protected function _adminFormFields() {

		$Model = $this->{$this->modelClass};
		$fields = parent::_adminFormFields();

		$fields[$Model->alias.'.product_attribute_id']['label'] = "Auto generate children from Attribute";
		$fields[$Model->alias.'.product_attribute_id']['type'] = "select";
		$fields[$Model->alias.'.product_attribute_id']['empty'] = "No";
		
		$fields[$Model->alias.'.parent_id']['empty'] = false;
		$fields[$Model->alias.'.parent_id']['type'] = "select";

		$fields['Route.alias']['url_prefix'] = 'category';

		return $fields;
	}


/**
 * Defines the fields displayed in a filter form.
 *
 * Defaults to id, display name, is_active, created and modified fields.
 *
 * Override in your controller to customise.
 *
 * Format:
 *
 * 'id' => array(
 *         'label' => label text,
 *         'type' => data type of control
 *         'compare' => SQL query. e.g. Model.field='%s' (where %s is replace by the value of the field)
 *         'default' => value you want the data filtering by by default
 * )
 */
	protected function _adminFilterFields() {

		$Model = $this->{$this->modelClass};
		$fields = parent::_adminFilterFields();

		unset($fields[$Model->alias.'.id']);
		unset($fields[$Model->alias.'.created']);
		unset($fields[$Model->alias.'.modified']);

		return $fields;

	}

}