<?php
App::uses('EvCatalogueAppModel', 'EvCatalogue.Model');

class Category extends EvCatalogueAppModel {

/**
 * Belongs to relations
 * @var string|array
 */
	public $belongsTo = [
		'ParentCategory' => [
			'className' => 'Category',
			'foreignKey' => 'parent_id',
		]
	];

	public $hasMany = [
		'CatalogueItem' => [
			'className' => 'EvCatalogue.CatalogueItem',
		]
	];

	public $actsAs = [
		'Routable.Routable' => [
			'alias' => 'catalogue/:displayField',
			'config' => 'EvCatalogue'
		],
		'MetaData.Meta'
	];

	public $imageSlots = [
		'listing' => [
			'slots' => 1,
			'fields' => [
				'alt'
			]
		]
	];

/**
 * Finds all children categories for a specified category ID
 *
 * @param int   $id    Category ID of parent
 * @param array $query Additional query array
 * @return array       Find All on Category
 */
	public function findAllChildren($id, $query = []) {
		$defaults = [
			'conditions' => [
				'parent_id' => $id,
				'is_active' => true
			],
			'order' => [
				'Category.name' => 'ASC'
			]
		];

		$query = Hash::merge($defaults, $query);
		return $this->readForIndex($query);
	}

/**
 * Finds all catalogue items for a specific category
 *
 * @param int $id ID of category
 * @return Array     A read for index
 */
	public function findAllCatalogueItemsFor($id) {
		return $this->CatalogueItem->readForIndex([
			'conditions' => [
				'category_id' => $id
			]
		]);
	}

/**
 * Finds all categories which have no parents
 *
 * @param array $query Additional query params to pass into readForIndex
 * @return array A readForIndex on Category
 */
	public function findAllTopLevelCategories($query = []) {
		$defaults = [
			'conditions' => [
				'parent_id IS NULL'
			]
		];

		$query = array_merge($defaults, $query);

		return $this->readForIndex($query);
	}
}
