<?php

App::uses('EvCatalogueAppModel', 'EvCatalogue.Model');

class CatalogueItem extends EvCatalogueAppModel {

	public $belongsTo = [
		'Category'
	];

	public $actsAs = [
		'Routable.Routable' => [
			'config' => 'EvCatalogue',
			'alias' => 'catalogue/:displayField'
		],
		'MetaData.Meta'
	];

	public $imageSlots = [
		'listing' => [
			'slots' => 1,
			'fields' => [
				'alt'
			]
		]
	];

/**
 * Gets a list of CatalogueItem names.  Useful for populating dropdowns/selects
 *
 * @return array Array of names
 */
	public function getNames() {
		$items = $this->find('all', [
			'conditions' => 'is_active'
		]);

		$names = Hash::extract($items, '{n}.CatalogueItem.name');

		return $names;
	}
}
